/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class Rack
extends GenericObject {
    private int height;

    public Rack(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.height = msg.getFieldAsInt32(441L);
    }

    @Override
    public String getObjectClassName() {
        return "Rack";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public List<AbstractNode> getUnits() {
        ArrayList<AbstractNode> units = new ArrayList<AbstractNode>();
        for (AbstractObject o : this.getChildsAsArray()) {
            if (!(o instanceof AbstractNode)) continue;
            units.add((AbstractNode)o);
        }
        Collections.sort(units, new Comparator<AbstractNode>(){

            @Override
            public int compare(AbstractNode node1, AbstractNode node2) {
                return node1.getRackPosition() - node2.getRackPosition();
            }
        });
        return units;
    }
}

