/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignBand
extends JRDesignElementGroup
implements JRBand {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_PRINT_WHEN_EXPRESSION = "printWhenExpression";
    public static final String PROPERTY_RETURN_VALUES = "returnValues";
    protected int height;
    protected SplitTypeEnum splitTypeValue;
    protected JRExpression printWhenExpression;
    private JROrigin origin;
    private JRPropertiesMap propertiesMap;
    protected List<ExpressionReturnValue> returnValues = new ArrayList<ExpressionReturnValue>(2);
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private boolean isSplitAllowed = true;
    private Byte splitType;

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        int old = this.height;
        this.height = height;
        this.getEventSupport().firePropertyChange(PROPERTY_HEIGHT, old, this.height);
    }

    @Override
    public SplitTypeEnum getSplitTypeValue() {
        return this.splitTypeValue;
    }

    @Override
    public void setSplitType(SplitTypeEnum splitTypeValue) {
        SplitTypeEnum old = this.splitTypeValue;
        this.splitTypeValue = splitTypeValue;
        this.getEventSupport().firePropertyChange("splitType", old, this.splitTypeValue);
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public void setPrintWhenExpression(JRExpression expression) {
        JRExpression old = this.printWhenExpression;
        this.printWhenExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_EXPRESSION, old, this.printWhenExpression);
    }

    public JROrigin getOrigin() {
        return this.origin;
    }

    void setOrigin(JROrigin origin) {
        this.origin = origin;
    }

    @Override
    public List<ExpressionReturnValue> getReturnValues() {
        return this.returnValues == null ? null : Collections.unmodifiableList(this.returnValues);
    }

    public void addReturnValue(ExpressionReturnValue returnValue) {
        this.returnValues.add(returnValue);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_RETURN_VALUES, returnValue, this.returnValues.size() - 1);
    }

    public List<ExpressionReturnValue> getReturnValuesList() {
        return this.returnValues;
    }

    public boolean removeReturnValue(ExpressionReturnValue returnValue) {
        int idx = this.returnValues.indexOf(returnValue);
        if (idx >= 0) {
            this.returnValues.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_RETURN_VALUES, returnValue, idx);
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        JRDesignBand clone = (JRDesignBand)super.clone();
        if (this.printWhenExpression != null) {
            clone.printWhenExpression = (JRExpression)this.printWhenExpression.clone();
        }
        if (this.origin != null) {
            clone.origin = (JROrigin)this.origin.clone();
        }
        clone.propertiesMap = JRPropertiesMap.getPropertiesClone(this);
        clone.returnValues = JRCloneUtils.cloneList(this.returnValues);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30502) {
            Byte by = this.splitType = this.isSplitAllowed ? SplitTypeEnum.STRETCH.getValueByte() : SplitTypeEnum.PREVENT.getValueByte();
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.splitTypeValue = SplitTypeEnum.getByValue(this.splitType);
            this.splitType = null;
        }
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }
}

