/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRImageReader;

public class JRJdk14ImageReader
implements JRImageReader {
    public static final String EXCEPTION_MESSAGE_KEY_IMAGE_READ_FAILED = "util.jdk14.image.read.failed";

    @Override
    public Image readImage(byte[] bytes) throws JRException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BufferedImage image = null;
        try {
            image = ImageIO.read(bais);
        }
        catch (Exception e) {
            throw new JRException(e);
        }
        finally {
            try {
                ((InputStream)bais).close();
            }
            catch (IOException e) {}
        }
        if (image == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_IMAGE_READ_FAILED, (Object[])null);
        }
        return image;
    }
}

