/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.RerunTimeDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.ScheduledTaskEditor;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScheduleTableEntryComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScheduleTableEntryLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ScheduledTaskView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.ScheduledTaskView";
    public static final int SCHEDULE_ID = 0;
    public static final int CALLBACK_ID = 1;
    public static final int OBJECT = 2;
    public static final int PARAMETERS = 3;
    public static final int EXECUTION_TIME = 4;
    public static final int LAST_EXECUTION_TIME = 5;
    public static final int STATUS = 6;
    public static final int OWNER = 7;
    private NXCSession session;
    private SessionListener listener;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionNewScheduledTask;
    private Action actionEditScheduledTask;
    private Action actionDeleteScheduledTask;
    private Action actionDisbaleScheduledTask;
    private Action actionEnableScheduledTask;
    private Action actionReRun;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{50, 100, 200, 400, 300, 300, 100, 100};
        String[] names = new String[]{"Id", "Schedule Type", "Object", "Parameters", "Execution time", "Last execution time", "Status", "Owner"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScheduleTableEntryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ScheduleTableEntryComparator());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1029) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ScheduledTaskView.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ScheduledTaskView.this.refresh();
            }
        };
        this.actionNewScheduledTask = new Action("New scheduled task...", SharedIcons.ADD_OBJECT){

            public void run() {
                ScheduledTaskView.this.createNewScheduledTask();
            }
        };
        this.actionEditScheduledTask = new Action("Edit", SharedIcons.EDIT){

            public void run() {
                ScheduledTaskView.this.editScheduledTask();
            }
        };
        this.actionDeleteScheduledTask = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ScheduledTaskView.this.deleteScheduledTask();
            }
        };
        this.actionDisbaleScheduledTask = new Action("Disable"){

            public void run() {
                ScheduledTaskView.this.setScheduledTaskEnabled(false);
            }
        };
        this.actionEnableScheduledTask = new Action("Enable"){

            public void run() {
                ScheduledTaskView.this.setScheduledTaskEnabled(true);
            }
        };
        this.actionReRun = new Action("Rerun", SharedIcons.EXECUTE){

            public void run() {
                ScheduledTaskView.this.rerun();
            }
        };
    }

    protected void rerun() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
        final RerunTimeDialog dialog = new RerunTimeDialog(this.getSite().getShell(), origin.getExecutionTime());
        if (dialog.open() != 0) {
            return;
        }
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                origin.setExecutionTime(dialog.getRerunDate());
                origin.setFlags(origin.getFlags() & 0xFFFFFFFD);
                ScheduledTaskView.this.session.updateSchedule(origin);
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    protected void deleteScheduledTask() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    ScheduledTaskView.this.session.removeSchedule(((ScheduledTask)o).getId());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete scheduled tasks";
            }
        }.start();
    }

    protected void editScheduledTask() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){
            private ScheduledTask task;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.task = null;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List taskList = ScheduledTaskView.this.session.listScheduleCallbacks();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledTaskEditor dialog = new ScheduledTaskEditor(ScheduledTaskView.this.getSite().getShell(), origin, taskList);
                        if (dialog.open() == 0) {
                            task = dialog.getScheduledTask();
                        }
                    }
                });
                if (this.task != null) {
                    ScheduledTaskView.this.session.updateSchedule(this.task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    protected void setScheduledTaskEnabled(final boolean enabled) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() < 0) {
            return;
        }
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object o : selection.toList()) {
                    ScheduledTask task = (ScheduledTask)o;
                    task.setEnabed(enabled);
                    ScheduledTaskView.this.session.updateSchedule(task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    private void createNewScheduledTask() {
        new ConsoleJob("Delete scheduled task", null, "org.netxms.ui.eclipse.serverconfig", null){
            private ScheduledTask task;
            {
                this.task = null;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List taskList = ScheduledTaskView.this.session.listScheduleCallbacks();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledTaskEditor dialog = new ScheduledTaskEditor(ScheduledTaskView.this.getSite().getShell(), null, taskList);
                        if (dialog.open() == 0) {
                            task = dialog.getScheduledTask();
                        }
                    }
                });
                if (this.task != null) {
                    ScheduledTaskView.this.session.addSchedule(this.task);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update scheduled tasks";
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewScheduledTask);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewScheduledTask);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScheduledTaskView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        mgr.add((IAction)this.actionNewScheduledTask);
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionEditScheduledTask);
            ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
            if (origin.getSchedule().isEmpty()) {
                mgr.add((IAction)this.actionReRun);
            }
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDeleteScheduledTask);
        }
        boolean containDisabled = false;
        boolean containEnabled = false;
        for (Object o : selection.toList()) {
            if (((ScheduledTask)o).isDisbaled()) {
                containDisabled = true;
            } else {
                containEnabled = true;
            }
            if (containDisabled && containEnabled) break;
        }
        if (containDisabled) {
            mgr.add((IAction)this.actionEnableScheduledTask);
        }
        if (containEnabled) {
            mgr.add((IAction)this.actionDisbaleScheduledTask);
        }
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.MappingTables_ReloadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List schedules = ScheduledTaskView.this.session.listScheduleTasks();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledTaskView.this.viewer.setInput((Object)schedules.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MappingTables_ReloadJobError;
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }
}

