/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netxms.client.IpAddressListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerVariable;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DiscoveryConfig {
    private boolean enabled;
    private boolean active;
    private boolean useSnmpTraps;
    private int filterFlags;
    private String filter;
    private List<IpAddressListElement> targets;
    private List<IpAddressListElement> addressFilter;

    private DiscoveryConfig() {
    }

    public static DiscoveryConfig load() throws NXCException, IOException {
        DiscoveryConfig config = new DiscoveryConfig();
        NXCSession session = ConsoleSharedData.getSession();
        Map variables = session.getServerVariables();
        config.enabled = DiscoveryConfig.getBoolean(variables, "RunNetworkDiscovery", false);
        config.active = DiscoveryConfig.getBoolean(variables, "ActiveNetworkDiscovery", false);
        config.useSnmpTraps = DiscoveryConfig.getBoolean(variables, "UseSNMPTrapsForDiscovery", false);
        config.filterFlags = DiscoveryConfig.getInteger(variables, "DiscoveryFilterFlags", 0);
        config.filter = DiscoveryConfig.getString(variables, "DiscoveryFilter", "none");
        config.addressFilter = session.getAddressList(2);
        config.targets = session.getAddressList(1);
        return config;
    }

    private static boolean getBoolean(Map<String, ServerVariable> variables, String name, boolean defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue()) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    private static int getInteger(Map<String, ServerVariable> variables, String name, int defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    private static String getString(Map<String, ServerVariable> variables, String name, String defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        return v.getValue();
    }

    public void save() throws NXCException, IOException {
        NXCSession session = ConsoleSharedData.getSession();
        session.setServerVariable("RunNetworkDiscovery", this.enabled ? "1" : "0");
        session.setServerVariable("ActiveNetworkDiscovery", this.active ? "1" : "0");
        session.setServerVariable("UseSNMPTrapsForDiscovery", this.useSnmpTraps ? "1" : "0");
        session.setServerVariable("DiscoveryFilterFlags", Integer.toString(this.filterFlags));
        session.setServerVariable("DiscoveryFilter", this.filter);
        session.setAddressList(2, this.addressFilter);
        session.setAddressList(1, this.targets);
        session.resetServerComponent(1);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getFilterFlags() {
        return this.filterFlags;
    }

    public void setFilterFlags(int filterFlags) {
        this.filterFlags = filterFlags;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<IpAddressListElement> getTargets() {
        return this.targets;
    }

    public void setTargets(List<IpAddressListElement> targets) {
        this.targets = targets;
    }

    public List<IpAddressListElement> getAddressFilter() {
        return this.addressFilter;
    }

    public void setAddressFilter(List<IpAddressListElement> addressFilter) {
        this.addressFilter = addressFilter;
    }

    public boolean isUseSnmpTraps() {
        return this.useSnmpTraps;
    }

    public void setUseSnmpTraps(boolean useSnmpTraps) {
        this.useSnmpTraps = useSnmpTraps;
    }
}

