/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.RackSelectionListener;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RackWidget
extends Canvas
implements PaintListener,
DisposeListener,
ImageUpdateListener,
MouseListener {
    private static final double UNIT_WH_RATIO = 10.85;
    private static final int BORDER_WIDTH_RATIO = 15;
    private static final int FULL_UNIT_WIDTH = 482;
    private static final int FULL_UNIT_HEIGHT = 45;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int UNIT_NUMBER_WIDTH = 30;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "Verdana", "Arial"};
    private Rack rack;
    private Font[] labelFonts;
    private Image imageDefaultTop;
    private Image imageDefaultMiddle;
    private Image imageDefaultBottom;
    private List<ObjectImage> objects = new ArrayList<ObjectImage>();
    private AbstractObject currentObject = null;
    private Set<RackSelectionListener> selectionListeners = new HashSet<RackSelectionListener>(0);

    public RackWidget(Composite parent, int style, Rack rack) {
        super(parent, style | 0x20000000);
        this.rack = rack;
        this.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)this.getDisplay()));
        String fontName = FontTools.findFirstAvailableFont((String[])FONT_NAMES);
        this.labelFonts = new Font[16];
        int i = 0;
        while (i < this.labelFonts.length) {
            this.labelFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
        this.imageDefaultTop = Activator.getImageDescriptor("icons/rack-default-top.png").createImage();
        this.imageDefaultMiddle = Activator.getImageDescriptor("icons/rack-default-middle.png").createImage();
        this.imageDefaultBottom = Activator.getImageDescriptor("icons/rack-default-bottom.png").createImage();
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addDisposeListener(this);
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
    }

    public AbstractObject getCurrentObject() {
        return this.currentObject;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setInterpolation(2);
        Rectangle rect = this.getClientArea();
        rect.x += 40;
        rect.y += 10;
        rect.height -= 20;
        double unitHeight = (double)rect.height / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        }
        rect.height -= borderWidth;
        unitHeight = (double)(rect.height - (borderWidth + 1) / 2 * 2) / (double)this.rack.getHeight();
        unitWidth = (int)(unitHeight * 10.85);
        rect.width = unitWidth + borderWidth * 2;
        gc.setBackground(SharedColors.getColor((String)"Rack.EmptySpace", (Display)this.getDisplay()));
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setLineWidth(borderWidth);
        gc.setForeground(SharedColors.getColor((String)"Rack.Border", (Display)this.getDisplay()));
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setBackground(SharedColors.getColor((String)"Rack.Border", (Display)this.getDisplay()));
        gc.fillRectangle(rect.x + borderWidth * 2 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        gc.fillRectangle(rect.x + rect.width - borderWidth * 3 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        int[] unitBaselines = new int[this.rack.getHeight() + 1];
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.labelFonts, (String)"00", (int)30, (int)((int)unitHeight - 2)));
        gc.setForeground(SharedColors.getColor((String)"Rack.Text", (Display)this.getDisplay()));
        gc.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)this.getDisplay()));
        gc.setLineWidth(1);
        double dy = rect.y + rect.height - (borderWidth + 1) / 2;
        int u = 1;
        while (u <= this.rack.getHeight()) {
            int y;
            unitBaselines[u - 1] = y = (int)dy;
            gc.drawLine(10, y, 30, y);
            String label = Integer.toString(u);
            Point textExtent = gc.textExtent(label);
            gc.drawText(label, 30 - textExtent.x, y - (int)unitHeight / 2 - textExtent.y / 2);
            ++u;
            dy -= unitHeight;
        }
        unitBaselines[this.rack.getHeight()] = (int)dy;
        this.objects.clear();
        List units = this.rack.getUnits();
        for (AbstractNode n : units) {
            if (n.getRackPosition() > this.rack.getHeight() || n.getRackPosition() - n.getRackHeight() < 0) continue;
            int bottomLine = unitBaselines[n.getRackPosition() - n.getRackHeight()];
            int topLine = unitBaselines[n.getRackPosition()];
            Rectangle unitRect = new Rectangle(rect.x + (borderWidth + 1) / 2, topLine + 1, rect.width - borderWidth, bottomLine - topLine);
            if (unitRect.width <= 0 || unitRect.height <= 0) break;
            this.objects.add(new ObjectImage((AbstractObject)n, unitRect));
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)n.getStatus()));
            gc.fillRectangle(unitRect.x - borderWidth + borderWidth / 4 + 1, unitRect.y + 1, borderWidth / 2 - 1, Math.min(borderWidth, (int)unitHeight - 2));
            if (n.getRackImage() != null && !n.getRackImage().equals(NXCommon.EMPTY_GUID)) {
                Image image = ImageProvider.getInstance().getImage(n.getRackImage());
                Rectangle r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            Rectangle r = this.imageDefaultTop.getBounds();
            if (n.getRackHeight() == 1) {
                gc.drawImage(this.imageDefaultTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            unitRect.height = unitBaselines[n.getRackPosition() - 1] - topLine;
            gc.drawImage(this.imageDefaultTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
            r = this.imageDefaultMiddle.getBounds();
            int u2 = n.getRackPosition() - 1;
            int i = 1;
            while (i < n.getRackHeight() - 1) {
                unitRect.y = unitBaselines[u2];
                unitRect.height = unitBaselines[u2 - 1] - unitRect.y;
                gc.drawImage(this.imageDefaultMiddle, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                ++i;
                --u2;
            }
            r = this.imageDefaultBottom.getBounds();
            unitRect.y = unitBaselines[u2];
            unitRect.height = unitBaselines[u2 - 1] - unitRect.y;
            gc.drawImage(this.imageDefaultBottom, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint == -1) {
            int borderWidth = 32;
            return new Point(532 + borderWidth * 2, this.rack.getHeight() * 45 + 20 + borderWidth * 2);
        }
        double unitHeight = (double)hHint / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        }
        unitWidth = (int)((double)(hHint - (borderWidth + 1) / 2 * 2 - 20) / (double)this.rack.getHeight() * 10.85);
        return new Point(unitWidth + 20 + 30 + borderWidth * 2, hHint);
    }

    public void widgetDisposed(DisposeEvent e) {
        int i = 0;
        while (i < this.labelFonts.length) {
            this.labelFonts[i].dispose();
            ++i;
        }
        this.imageDefaultTop.dispose();
        this.imageDefaultMiddle.dispose();
        this.imageDefaultBottom.dispose();
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
    }

    public void imageUpdated(UUID guid) {
        boolean found = false;
        List units = this.rack.getUnits();
        for (AbstractNode n : units) {
            if (!guid.equals(n.getRackImage())) continue;
            found = true;
            break;
        }
        if (found) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RackWidget.this.redraw();
                }
            });
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        AbstractObject o = null;
        Point p = new Point(e.x, e.y);
        for (ObjectImage i : this.objects) {
            if (!i.contains(p)) continue;
            o = i.getObject();
            break;
        }
        this.setCurrentObject(o);
    }

    public void mouseUp(MouseEvent e) {
    }

    public void addSelectionListener(RackSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(RackSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void setCurrentObject(AbstractObject o) {
        this.currentObject = o;
        for (RackSelectionListener l : this.selectionListeners) {
            l.objectSelected(this.currentObject);
        }
    }

    private class ObjectImage {
        private AbstractObject object;
        private Rectangle rect;

        public ObjectImage(AbstractObject object, Rectangle rect) {
            this.object = object;
            this.rect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }

        public boolean contains(Point p) {
            return this.rect.contains(p);
        }

        public AbstractObject getObject() {
            return this.object;
        }
    }
}

