/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.server.AgentFile;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class AgentFileLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                return ((AgentFile)element).getExtension();
            }
            case 2: {
                return ((AgentFile)element).isDirectory() || ((AgentFile)element).isPlaceholder() ? "" : Long.toString(((AgentFile)element).getSize());
            }
            case 3: {
                return ((AgentFile)element).isPlaceholder() || ((AgentFile)element).getModifyicationTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(((AgentFile)element).getModifyicationTime());
            }
            case 4: {
                return ((AgentFile)element).getOwner();
            }
            case 5: {
                return ((AgentFile)element).getGroup();
            }
            case 6: {
                return ((AgentFile)element).getAccessRights();
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.wbLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.wbLabelProvider.getText(element);
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        super.dispose();
    }

    public Color getForeground(Object element) {
        if (((AgentFile)element).isPlaceholder()) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

