/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.nxsl.Activator;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLDocument;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLSourceViewerConfiguration;

public class ScriptEditor
extends Composite {
    private SourceViewer editor;
    private CompositeRuler ruler;
    private Set<String> functions = new HashSet<String>(0);
    private Set<String> variables = new HashSet<String>(0);
    private String[] functionsCache = new String[0];
    private String[] variablesCache = new String[0];
    private Image[] proposalIcons = new Image[4];
    private String hintText;
    private Composite hintArea;
    private Text hintTextControl = null;
    private Label hintsExpandButton = null;

    public ScriptEditor(Composite parent, int style, int editorStyle) {
        this(parent, style, editorStyle, true, null);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers) {
        this(parent, style, editorStyle, showLineNumbers, null);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers, String hints) {
        super(parent, style);
        this.hintText = hints;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        if (hints != null) {
            this.createHintsArea();
        }
        this.proposalIcons[0] = Activator.getImageDescriptor("icons/function.gif").createImage();
        this.proposalIcons[1] = Activator.getImageDescriptor("icons/var_global.gif").createImage();
        this.proposalIcons[2] = Activator.getImageDescriptor("icons/var_local.gif").createImage();
        this.proposalIcons[3] = Activator.getImageDescriptor("icons/constant.gif").createImage();
        this.ruler = new CompositeRuler();
        this.editor = new SourceViewer((Composite)this, (IVerticalRuler)this.ruler, editorStyle);
        this.editor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.configure((SourceViewerConfiguration)new NXSLSourceViewerConfiguration(this));
        if (showLineNumbers) {
            this.ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        }
        final TextViewerUndoManager undoManager = new TextViewerUndoManager(50);
        this.editor.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.editor);
        this.editor.getFindReplaceTarget();
        this.editor.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (!event.doit) {
                    return;
                }
                if (event.stateMask == SWT.MOD1) {
                    switch (event.character) {
                        case ' ': {
                            ScriptEditor.this.editor.doOperation(13);
                            event.doit = false;
                            break;
                        }
                        case '\u0019': {
                            undoManager.redo();
                            event.doit = false;
                            break;
                        }
                        case '\u001a': {
                            undoManager.undo();
                            event.doit = false;
                        }
                    }
                } else if (event.stateMask == 0) {
                    if (event.character == '\t' && ((ScriptEditor)ScriptEditor.this).editor.getSelectedRange().y > 0) {
                        ScriptEditor.this.editor.doOperation(8);
                        event.doit = false;
                    }
                } else if (event.stateMask == 131072 && event.character == '\t' && ((ScriptEditor)ScriptEditor.this).editor.getSelectedRange().y > 0) {
                    ScriptEditor.this.editor.doOperation(9);
                    event.doit = false;
                }
            }
        });
        StyledText control = this.editor.getTextWidget();
        control.setFont(JFaceResources.getTextFont());
        control.setWordWrap(false);
        this.editor.setDocument((IDocument)new NXSLDocument(""));
    }

    private void createHintsArea() {
        this.hintArea = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.hintArea.setLayout((Layout)layout);
        this.hintArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hintArea.setBackground(SharedColors.getColor((String)"MessageBar.Background", (Display)this.getDisplay()));
        CLabel hintsTitle = new CLabel(this.hintArea, 0);
        hintsTitle.setBackground(SharedColors.getColor((String)"MessageBar.Background", (Display)this.getDisplay()));
        hintsTitle.setForeground(SharedColors.getColor((String)"MessageBar.Text", (Display)this.getDisplay()));
        hintsTitle.setImage(SharedIcons.IMG_INFORMATION);
        hintsTitle.setText("Hints");
        hintsTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        hintsTitle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    ScriptEditor.this.toggleHints();
                }
            }
        });
        this.hintsExpandButton = new Label(this.hintArea, 0);
        this.hintsExpandButton.setBackground(this.hintArea.getBackground());
        this.hintsExpandButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        this.hintsExpandButton.setToolTipText("Hide message");
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.hintsExpandButton.setLayoutData((Object)gd);
        this.hintsExpandButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    ScriptEditor.this.toggleHints();
                }
            }
        });
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public void dispose() {
        int i = 0;
        while (i < this.proposalIcons.length) {
            this.proposalIcons[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public StyledText getTextWidget() {
        return this.editor.getTextWidget();
    }

    public void setText(String text) {
        this.editor.setDocument((IDocument)new NXSLDocument(text));
    }

    public String getText() {
        return this.editor.getDocument().get();
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
        this.functionsCache = functions.toArray(new String[functions.size()]);
    }

    public void addFunctions(Collection<String> fc) {
        this.functions.addAll(fc);
        this.functionsCache = this.functions.toArray(new String[this.functions.size()]);
    }

    public void setVariables(Set<String> variables) {
        this.variables = variables;
        this.variablesCache = variables.toArray(new String[variables.size()]);
    }

    public void addVariables(Collection<String> vc) {
        this.variables.addAll(vc);
        this.variablesCache = this.variables.toArray(new String[this.variables.size()]);
    }

    public String[] getFunctions() {
        return this.functionsCache;
    }

    public String[] getVariables() {
        return this.variablesCache;
    }

    public Image getProposalIcon(int type) {
        try {
            return this.proposalIcons[type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        return this.editor.getFindReplaceTarget();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = this.editor.getTextWidget().computeSize(wHint, hHint, changed);
        p.y += 4;
        return p;
    }

    public void showLineNumbers(boolean show) {
        if (show) {
            if (!this.ruler.getDecoratorIterator().hasNext()) {
                this.ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
            }
        } else if (this.ruler.getDecoratorIterator().hasNext()) {
            this.ruler.removeDecorator(0);
        }
    }

    private void toggleHints() {
        if (this.hintTextControl != null) {
            this.hintTextControl.dispose();
            this.hintTextControl = null;
            this.hintsExpandButton.setImage(SharedIcons.IMG_EXPAND);
        } else {
            this.hintTextControl = new Text(this.hintArea, 66);
            this.hintTextControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.hintTextControl.setEditable(false);
            this.hintTextControl.setText(this.hintText);
            this.hintTextControl.setBackground(SharedColors.getColor((String)"MessageBar.Background", (Display)this.getDisplay()));
            this.hintTextControl.setForeground(SharedColors.getColor((String)"MessageBar.Text", (Display)this.getDisplay()));
            this.hintsExpandButton.setImage(SharedIcons.IMG_COLLAPSE);
        }
        this.layout(true, true);
    }
}

