/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.InetAddressEx;
import org.netxms.client.MacAddress;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.IPAddressValidator;
import org.netxms.ui.eclipse.tools.IPNetMaskValidator;
import org.netxms.ui.eclipse.tools.MacAddressValidator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.ObjectNameValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateInterfaceDialog
extends Dialog {
    private static final int DEFAULT_MASK_BITS = 8;
    private LabeledText nameField;
    private LabeledText macAddrField;
    private LabeledText ipAddrField;
    private LabeledText ipMaskField;
    private Button checkIsPhy;
    private LabeledText slotField;
    private LabeledText portField;
    private String name;
    private MacAddress macAddress;
    private InetAddressEx ipAddress;
    private int ifIndex;
    private int ifType;
    private int slot;
    private int port;
    private boolean physicalPort;

    public CreateInterfaceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateInterfaceDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.nameField.setLabel(Messages.CreateInterfaceDialog_Name);
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.macAddrField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.macAddrField.setLabel(Messages.CreateInterfaceDialog_MACAddr);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.macAddrField.setLayoutData((Object)gd);
        this.ipAddrField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.ipAddrField.setLabel(Messages.CreateInterfaceDialog_IPAddr);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipAddrField.setLayoutData((Object)gd);
        this.ipMaskField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.ipMaskField.setLabel(Messages.CreateInterfaceDialog_IPNetMak);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipMaskField.setLayoutData((Object)gd);
        this.checkIsPhy = new Button(dialogArea, 32);
        Messages.get();
        this.checkIsPhy.setText(Messages.CreateInterfaceDialog_IsPhysicalPort);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkIsPhy.setLayoutData((Object)gd);
        this.checkIsPhy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateInterfaceDialog.this.slotField.setEnabled(CreateInterfaceDialog.this.checkIsPhy.getSelection());
                CreateInterfaceDialog.this.portField.setEnabled(CreateInterfaceDialog.this.checkIsPhy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.slotField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.slotField.setLabel(Messages.CreateInterfaceDialog_Slot);
        this.slotField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.slotField.setLayoutData((Object)gd);
        this.slotField.setEnabled(false);
        this.portField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.portField.setLabel(Messages.CreateInterfaceDialog_Port);
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.portField.setEnabled(false);
        return dialogArea;
    }

    protected void okPressed() {
        this.physicalPort = this.checkIsPhy.getSelection();
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator(), null) || !WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipAddrField, (TextFieldValidator)new IPAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipMaskField, (TextFieldValidator)new IPNetMaskValidator(true), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.slotField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.portField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null)) {
            return;
        }
        try {
            this.name = this.nameField.getText().trim();
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            InetAddress addr = this.ipAddrField.getText().trim().isEmpty() ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(this.ipAddrField.getText());
            this.ipAddress = new InetAddressEx(addr, this.getMaskBits(this.ipMaskField.getText().trim(), addr instanceof Inet4Address ? 32 : 128));
            this.slot = this.physicalPort ? Integer.parseInt(this.slotField.getText()) : 0;
            this.port = this.physicalPort ? Integer.parseInt(this.portField.getText()) : 0;
            super.okPressed();
        }
        catch (Exception e) {
            Shell shell = this.getShell();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.CreateInterfaceDialog_Error, (String)String.format("Internal error: %s", e.getMessage()));
        }
    }

    private int getMaskBits(String mask, int maxBits) {
        if (mask.isEmpty()) {
            return 8;
        }
        try {
            int bits = Integer.parseInt(mask);
            return bits >= 0 && bits <= maxBits ? bits : 8;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                InetAddress addr = InetAddress.getByName(mask);
                return InetAddressEx.bitsInMask((InetAddress)addr);
            }
            catch (UnknownHostException unknownHostException) {
                return 8;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isPhysicalPort() {
        return this.physicalPort;
    }
}

