/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Cluster;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.dialogs.ClusterNetworkEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.NetworkListComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.NetworkListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ClusterNetworks
extends PropertyPage {
    public static final int COLUMN_ADDRESS = 0;
    public static final int COLUMN_NETMASK = 1;
    private Cluster object;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<InetAddressEx> networks = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Cluster)this.getElement().getAdapter(Cluster.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ClusterNetworks_ColAddress;
        Messages.get();
        stringArray[1] = Messages.ClusterNetworks_ColMask;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NetworkListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NetworkListComparator());
        this.networks = new ArrayList<InetAddressEx>(this.object.getSyncNetworks().size());
        for (InetAddressEx n : this.object.getSyncNetworks()) {
            this.networks.add(new InetAddressEx(n));
        }
        this.viewer.setInput((Object)this.networks.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.ClusterNetworks_Add);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterNetworks.this.addNetwork();
            }
        });
        this.editButton = new Button(buttons, 8);
        Messages.get();
        this.editButton.setText(Messages.ClusterNetworks_Modify);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterNetworks.this.editNetwork();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.ClusterNetworks_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterNetworks.this.deleteNetwork();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ClusterNetworks.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ClusterNetworks.this.viewer.getSelection();
                ClusterNetworks.this.editButton.setEnabled(selection.size() == 1);
                ClusterNetworks.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    private void addNetwork() {
        ClusterNetworkEditDialog dlg = new ClusterNetworkEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            InetAddressEx n = new InetAddressEx(dlg.getAddress(), dlg.getMask());
            this.networks.add(n);
            this.viewer.setInput((Object)this.networks.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)n));
            this.isModified = true;
        }
    }

    private void editNetwork() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InetAddressEx n = (InetAddressEx)selection.getFirstElement();
        ClusterNetworkEditDialog dlg = new ClusterNetworkEditDialog(this.getShell(), n.address, n.maskFromBits());
        if (dlg.open() == 0) {
            n.address = dlg.getAddress();
            n.mask = InetAddressEx.bitsInMask((InetAddress)dlg.getMask());
            this.viewer.update((Object)n, null);
            this.isModified = true;
        }
    }

    private void deleteNetwork() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        for (Object o : selection.toList()) {
            this.networks.remove(o);
        }
        this.viewer.setInput((Object)this.networks.toArray());
        this.isModified = true;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setNetworkList(this.networks);
        Messages.get();
        new ConsoleJob(Messages.ClusterNetworks_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                ClusterNetworks.this.isModified = false;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ClusterNetworks_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ClusterNetworks.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

