/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IDisposeListener;
import org.swtchart.IErrorBar;
import org.swtchart.ISeries;
import org.swtchart.ISeriesLabel;
import org.swtchart.Range;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.compress.ICompress;
import org.swtchart.internal.series.ErrorBar;
import org.swtchart.internal.series.SeriesLabel;
import org.swtchart.internal.series.SeriesSet;

public abstract class Series
implements ISeries {
    protected static final ISeries.SeriesType DEFAULT_SERIES_TYPE = ISeries.SeriesType.LINE;
    protected double[] xSeries;
    protected double[] ySeries;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected double avgY;
    protected String id;
    protected String name = null;
    protected ICompress compressor;
    protected int xAxisId;
    protected int yAxisId;
    protected boolean visible;
    protected boolean isXMonotoneIncreasing;
    protected ISeries.SeriesType type;
    protected SeriesLabel seriesLabel;
    protected ErrorBar xErrorBar;
    protected ErrorBar yErrorBar;
    protected Chart chart;
    protected boolean stackEnabled;
    protected double[] stackSeries;
    private boolean isDateSeries;
    private List<IDisposeListener> listeners;

    protected Series(Chart chart, String id) {
        this.chart = chart;
        this.id = id;
        this.xAxisId = 0;
        this.yAxisId = 0;
        this.visible = true;
        this.type = DEFAULT_SERIES_TYPE;
        this.stackEnabled = false;
        this.isXMonotoneIncreasing = true;
        this.seriesLabel = new SeriesLabel();
        this.xErrorBar = new ErrorBar();
        this.yErrorBar = new ErrorBar();
        this.listeners = new ArrayList<IDisposeListener>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ISeries.SeriesType getType() {
        return this.type;
    }

    @Override
    public boolean isStackEnabled() {
        return this.stackEnabled;
    }

    @Override
    public void enableStack(boolean enabled, boolean update) {
        if (enabled && this.minY < 0.0) {
            throw new IllegalStateException("Stacked series cannot contain minus values.");
        }
        if (this.stackEnabled == enabled) {
            return;
        }
        this.stackEnabled = enabled;
        if (update) {
            ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
        }
    }

    @Override
    public void setXSeries(double[] series) {
        IAxis axis;
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        this.xSeries = new double[series.length];
        System.arraycopy(series, 0, this.xSeries, 0, series.length);
        this.isDateSeries = false;
        if (this.xSeries.length == 0) {
            return;
        }
        this.minX = this.xSeries[0];
        this.maxX = this.xSeries[0];
        int i = 1;
        while (i < this.xSeries.length) {
            if (this.minX > this.xSeries[i]) {
                this.minX = this.xSeries[i];
            }
            if (this.maxX < this.xSeries[i]) {
                this.maxX = this.xSeries[i];
            }
            if (this.xSeries[i - 1] > this.xSeries[i]) {
                this.isXMonotoneIncreasing = false;
            }
            ++i;
        }
        this.setCompressor();
        this.compressor.setXSeries(this.xSeries);
        if (this.ySeries != null) {
            this.compressor.setYSeries(this.ySeries);
        }
        if (this.minX <= 0.0 && (axis = this.chart.getAxisSet().getXAxis(this.xAxisId)) != null) {
            axis.enableLogScale(false);
        }
    }

    @Override
    public double[] getXSeries() {
        if (this.xSeries == null) {
            return null;
        }
        double[] copiedSeries = new double[this.xSeries.length];
        System.arraycopy(this.xSeries, 0, copiedSeries, 0, this.xSeries.length);
        return copiedSeries;
    }

    @Override
    public void setYSeries(double[] series) {
        IAxis axis;
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        this.ySeries = new double[series.length];
        System.arraycopy(series, 0, this.ySeries, 0, series.length);
        if (this.ySeries.length == 0) {
            return;
        }
        this.minY = this.ySeries[0];
        this.maxY = this.ySeries[0];
        double sum = this.ySeries[0];
        int i = 1;
        while (i < this.ySeries.length) {
            if (this.minY > this.ySeries[i]) {
                this.minY = this.ySeries[i];
            }
            if (this.maxY < this.ySeries[i]) {
                this.maxY = this.ySeries[i];
            }
            sum += this.ySeries[i];
            ++i;
        }
        this.avgY = sum / (double)this.ySeries.length;
        if (this.xSeries == null || this.xSeries.length != series.length) {
            this.xSeries = new double[series.length];
            i = 0;
            while (i < series.length) {
                this.xSeries[i] = i;
                ++i;
            }
            this.minX = this.xSeries[0];
            this.maxX = this.xSeries[this.xSeries.length - 1];
            this.isXMonotoneIncreasing = true;
        }
        this.setCompressor();
        this.compressor.setXSeries(this.xSeries);
        this.compressor.setYSeries(this.ySeries);
        if (this.minX < 0.0 && (axis = this.chart.getAxisSet().getXAxis(this.xAxisId)) != null) {
            axis.enableLogScale(false);
        }
        if (this.minY < 0.0) {
            axis = this.chart.getAxisSet().getYAxis(this.yAxisId);
            if (axis != null) {
                axis.enableLogScale(false);
            }
            this.stackEnabled = false;
        }
    }

    @Override
    public double[] getYSeries() {
        if (this.ySeries == null) {
            return null;
        }
        double[] copiedSeries = new double[this.ySeries.length];
        System.arraycopy(this.ySeries, 0, copiedSeries, 0, this.ySeries.length);
        return copiedSeries;
    }

    @Override
    public void setXDateSeries(Date[] series) {
        if (series == null) {
            SWT.error((int)4);
            return;
        }
        double[] xDateSeries = new double[series.length];
        int i = 0;
        while (i < series.length) {
            xDateSeries[i] = series[i].getTime();
            ++i;
        }
        this.setXSeries(xDateSeries);
        this.isDateSeries = true;
    }

    @Override
    public Date[] getXDateSeries() {
        if (!this.isDateSeries) {
            return null;
        }
        Date[] series = new Date[this.xSeries.length];
        int i = 0;
        while (i < series.length) {
            series[i] = new Date((long)this.xSeries[i]);
            ++i;
        }
        return series;
    }

    public boolean isDateSeries() {
        return this.isDateSeries;
    }

    public boolean isValidStackSeries() {
        return this.stackEnabled && this.stackSeries != null && this.stackSeries.length > 0 && !this.chart.getAxisSet().getYAxis(this.yAxisId).isLogScaleEnabled();
    }

    public Range getXRange() {
        return new Range(this.minX, this.maxX);
    }

    public abstract Range getAdjustedRange(Axis var1, int var2);

    public Range getYRange() {
        double min = this.minY;
        double max = this.maxY;
        if (this.isValidStackSeries()) {
            int i = 0;
            while (i < this.stackSeries.length) {
                if (max < this.stackSeries[i]) {
                    max = this.stackSeries[i];
                }
                ++i;
            }
        }
        return new Range(min, max);
    }

    protected ICompress getCompressor() {
        return this.compressor;
    }

    protected abstract void setCompressor();

    @Override
    public int getXAxisId() {
        return this.xAxisId;
    }

    @Override
    public void setXAxisId(int id) {
        if (this.xAxisId == id) {
            return;
        }
        IAxis axis = this.chart.getAxisSet().getXAxis(this.xAxisId);
        if (this.minX <= 0.0 && axis != null && axis.isLogScaleEnabled()) {
            this.chart.getAxisSet().getXAxis(this.xAxisId).enableLogScale(false);
        }
        this.xAxisId = id;
        ((SeriesSet)this.chart.getSeriesSet()).updateStackAndRiserData();
    }

    @Override
    public int getYAxisId() {
        return this.yAxisId;
    }

    @Override
    public void setYAxisId(int id) {
        this.yAxisId = id;
    }

    @Override
    public ISeriesLabel getLabel() {
        return this.seriesLabel;
    }

    @Override
    public IErrorBar getXErrorBar() {
        return this.xErrorBar;
    }

    @Override
    public IErrorBar getYErrorBar() {
        return this.yErrorBar;
    }

    protected void setStackSeries(double[] stackSeries) {
        this.stackSeries = stackSeries;
    }

    @Override
    public Point getPixelCoordinates(int index) {
        IAxis vAxis;
        IAxis hAxis;
        if (this.chart.getOrientation() == 256) {
            hAxis = this.chart.getAxisSet().getXAxis(this.xAxisId);
            vAxis = this.chart.getAxisSet().getYAxis(this.yAxisId);
        } else if (this.chart.getOrientation() == 512) {
            hAxis = this.chart.getAxisSet().getYAxis(this.yAxisId);
            vAxis = this.chart.getAxisSet().getXAxis(this.xAxisId);
        } else {
            throw new IllegalStateException("unknown chart orientation");
        }
        return new Point(this.getPixelCoordinate(hAxis, index), this.getPixelCoordinate(vAxis, index));
    }

    private int getPixelCoordinate(IAxis axis, int index) {
        double dataCoordinate;
        if (axis.getDirection() == IAxis.Direction.X) {
            if (axis.isCategoryEnabled()) {
                dataCoordinate = index;
            } else {
                if (index < 0 || this.xSeries.length <= index) {
                    throw new IllegalArgumentException("Series index is out of range.");
                }
                dataCoordinate = this.xSeries[index];
            }
        } else if (axis.getDirection() == IAxis.Direction.Y) {
            if (this.isValidStackSeries()) {
                if (index < 0 || this.stackSeries.length <= index) {
                    throw new IllegalArgumentException("Series index is out of range.");
                }
                dataCoordinate = this.stackSeries[index];
            } else {
                if (index < 0 || this.ySeries.length <= index) {
                    throw new IllegalArgumentException("Series index is out of range.");
                }
                dataCoordinate = this.ySeries[index];
            }
        } else {
            throw new IllegalStateException("unknown axis direction");
        }
        return axis.getPixelCoordinate(dataCoordinate);
    }

    protected Range getRangeWithMargin(int lowerPlotMargin, int upperPlotMargin, int length, Axis axis, Range range) {
        if (length == 0) {
            return range;
        }
        int lowerPixelCoordinate = axis.getPixelCoordinate(range.lower, range.lower, range.upper) + lowerPlotMargin * (axis.isHorizontalAxis() ? -1 : 1);
        int upperPixelCoordinate = axis.getPixelCoordinate(range.upper, range.lower, range.upper) + upperPlotMargin * (axis.isHorizontalAxis() ? 1 : -1);
        double lower = axis.getDataCoordinate(lowerPixelCoordinate, range.lower, range.upper);
        double upper = axis.getDataCoordinate(upperPixelCoordinate, range.lower, range.upper);
        return new Range(lower, upper);
    }

    protected void dispose() {
        for (IDisposeListener listener : this.listeners) {
            listener.disposed(new Event());
        }
    }

    @Override
    public void addDisposeListener(IDisposeListener listener) {
        this.listeners.add(listener);
    }

    public void draw(GC gc, int width, int height) {
        if (!this.visible || width < 0 || height < 0 || this.xSeries == null || this.xSeries.length == 0 || this.ySeries == null || this.ySeries.length == 0) {
            return;
        }
        Axis xAxis = (Axis)this.chart.getAxisSet().getXAxis(this.getXAxisId());
        Axis yAxis = (Axis)this.chart.getAxisSet().getYAxis(this.getYAxisId());
        if (xAxis == null || yAxis == null) {
            return;
        }
        this.draw(gc, width, height, xAxis, yAxis);
    }

    protected abstract void draw(GC var1, int var2, int var3, Axis var4, Axis var5);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getAvgY() {
        return this.avgY;
    }

    public double getCurY() {
        return this.ySeries != null && this.ySeries.length > 0 ? this.ySeries[0] : 0.0;
    }

    @Override
    public int getSize() {
        return this.xSeries.length;
    }
}

