/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.certificate.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import org.netxms.certificate.loader.KeyStoreLoader;
import org.netxms.certificate.loader.KeyStoreRequestListener;
import org.netxms.certificate.loader.exception.KeyStoreLoaderException;

public class PKCS12KeyStoreLoader
implements KeyStoreLoader {
    private KeyStoreRequestListener listener;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyStore loadKeyStore() throws KeyStoreLoaderException {
        KeyStore ks;
        if (this.listener == null) {
            throw new KeyStoreLoaderException("KeyStoreRequestListener not set!");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            String ksLocation = this.listener.keyStoreLocationRequested();
            if (ksLocation == null) {
                return null;
            }
            FileInputStream fis = new FileInputStream(ksLocation);
            try {
                try {
                    ks.load(fis, new char[0]);
                }
                catch (IOException iOException) {
                    fis.close();
                    fis = new FileInputStream(ksLocation);
                    String keyStorePassword = this.listener.keyStorePasswordRequested();
                    if (keyStorePassword == null || keyStorePassword.isEmpty()) {
                        fis.close();
                        return null;
                    }
                    ks.load(fis, keyStorePassword.toCharArray());
                }
            }
            finally {
                fis.close();
            }
        }
        catch (Exception e) {
            throw new KeyStoreLoaderException(e.getMessage());
        }
        return ks;
    }

    @Override
    public void setKeyStoreRequestListener(KeyStoreRequestListener listener) {
        this.listener = listener;
    }
}

