/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum MapObjectDisplayMode {
    ICON(0),
    SMALL_LABEL(1),
    LARGE_LABEL(2),
    STATUS(3);

    private int value;
    private static Map<Integer, MapObjectDisplayMode> lookupTable;

    static {
        lookupTable = new HashMap<Integer, MapObjectDisplayMode>();
        MapObjectDisplayMode[] mapObjectDisplayModeArray = MapObjectDisplayMode.values();
        int n = mapObjectDisplayModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapObjectDisplayMode element = mapObjectDisplayModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private MapObjectDisplayMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MapObjectDisplayMode getByValue(int value) {
        MapObjectDisplayMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(MapObjectDisplayMode.class.getName(), "Unknown element " + value);
            return ICON;
        }
        return element;
    }
}

