/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import java.text.NumberFormat;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NodeLink;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceCheck;
import org.netxms.client.objects.ServiceContainer;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeneralInfo
extends TableElement {
    public GeneralInfo(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected void fillTable() {
        AbstractObject object = this.getObject();
        NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        this.addPair(Messages.GeneralInfo_ID, Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_GUID, object.getGuid().toString());
        }
        Messages.get();
        this.addPair(Messages.GeneralInfo_Class, object.getObjectClassName());
        if (object.isInMaintenanceMode()) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_Status, String.valueOf(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus())) + " (maintenance)");
        } else {
            Messages.get();
            this.addPair(Messages.GeneralInfo_Status, StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        switch (object.getObjectClass()) {
            case 3: {
                Interface iface = (Interface)object;
                Messages.get();
                this.addPair(Messages.GeneralInfo_IfIndex, Integer.toString(iface.getIfIndex()));
                String typeName = iface.getIfTypeName();
                Messages.get();
                this.addPair(Messages.GeneralInfo_IfType, typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType()));
                Messages.get();
                this.addPair(Messages.GeneralInfo_Description, iface.getDescription(), false);
                this.addPair("Alias", iface.getAlias(), false);
                if (iface.getMtu() > 0) {
                    this.addPair("MTU", Integer.toString(iface.getMtu()));
                }
                if (iface.getSpeed() > 0L) {
                    this.addPair("Speed", InterfaceListLabelProvider.ifSpeedTotext(iface.getSpeed()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_MACAddr, iface.getMacAddress().toString());
                if ((iface.getFlags() & 2) != 0) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_SlotPort, String.valueOf(Integer.toString(iface.getSlot())) + "/" + Integer.toString(iface.getPort()));
                    AbstractNode node = iface.getParentNode();
                    if (node != null && node.is8021xSupported()) {
                        Messages.get();
                        this.addPair(Messages.GeneralInfo_8021xPAE, iface.getDot1xPaeStateAsText());
                        Messages.get();
                        this.addPair(Messages.GeneralInfo_8021xBackend, iface.getDot1xBackendStateAsText());
                    }
                }
                if (iface.getIpAddressList().size() > 0) {
                    if (session.isZoningEnabled()) {
                        Messages.get();
                        this.addPair(Messages.GeneralInfo_ZoneId, Long.toString(iface.getZoneId()));
                    }
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_IPAddr, ((InetAddressEx)iface.getIpAddressList().get(0)).toString());
                    int i = 1;
                    while (i < iface.getIpAddressList().size()) {
                        this.addPair("", ((InetAddressEx)iface.getIpAddressList().get(i)).toString());
                        ++i;
                    }
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_AdmState, iface.getAdminStateAsText());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OperState, iface.getOperStateAsText());
                break;
            }
            case 2: {
                Rack rack;
                AbstractNode node = (AbstractNode)object;
                if (session.isZoningEnabled()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_ZoneId, Long.toString(node.getZoneId()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_PrimaryHostName, node.getPrimaryName());
                Messages.get();
                this.addPair(Messages.GeneralInfo_PrimaryIP, node.getPrimaryIP().getHostAddress());
                if (node.hasAgent()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_AgentVersion, node.getAgentVersion());
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysDescr, node.getSystemDescription(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_PlatformName, node.getPlatformName(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysName, node.getSnmpSysName(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysOID, node.getSnmpOID(), false);
                this.addPair("SNMP sysLocation", node.getSnmpSysLocation(), false);
                this.addPair("SNMP sysContact", node.getSnmpSysContact(), false);
                if ((node.getFlags() & 4) != 0) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_BridgeBaseAddress, node.getBridgeBaseAddress().toString());
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_Driver, node.getDriverName(), false);
                if (node.getBootTime() != null) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_BootTime, RegionalSettings.getDateTimeFormat().format(node.getBootTime()), false);
                }
                if (node.getRackId() == 0L || (rack = (Rack)session.findObjectById(node.getRackId(), Rack.class)) == null) break;
                this.addPair("Rack", String.format("%s (units %d-%d)", rack.getObjectName(), node.getRackPosition() - node.getRackHeight() + 1, node.getRackPosition()));
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    Messages.get();
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LastReport, Messages.GeneralInfo_Never);
                } else {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LastReport, RegionalSettings.getDateTimeFormat().format(md.getLastReportTime()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_DeviceId, md.getDeviceId());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Vendor, md.getVendor());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Model, md.getModel());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Serial, md.getSerialNumber());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OS, md.getOsName());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OSVersion, md.getOsVersion());
                Messages.get();
                this.addPair(Messages.GeneralInfo_User, md.getUserId(), false);
                if (md.getBatteryLevel() < 0) break;
                Messages.get();
                this.addPair(Messages.GeneralInfo_BatteryLevel, String.valueOf(Integer.toString(md.getBatteryLevel())) + "%");
                break;
            }
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                Messages.get();
                this.addPair(Messages.GeneralInfo_State, ap.getState().toString());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Vendor, ap.getVendor());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Model, ap.getModel());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Serial, ap.getSerialNumber());
                Messages.get();
                this.addPair(Messages.GeneralInfo_MACAddr, ap.getMacAddress().toString());
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (session.isZoningEnabled()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_ZoneId, Long.toString(subnet.getZoneId()));
                }
                this.addPair("IP Address", subnet.getNetworkAddress().toString());
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                Messages.get();
                this.addPair(Messages.GeneralInfo_ZoneId, Long.toString(zone.getZoneId()));
                break;
            }
            case 29: {
                AbstractNode linkedNode = (AbstractNode)session.findObjectById(((NodeLink)object).getNodeId(), AbstractNode.class);
                if (linkedNode != null) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LinkedNode, linkedNode.getObjectName());
                }
            }
            case 27: 
            case 28: {
                ServiceContainer service = (ServiceContainer)object;
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMinimumFractionDigits(3);
                nf.setMaximumFractionDigits(3);
                Messages.get();
                this.addPair(Messages.GeneralInfo_UptimeDay, String.valueOf(nf.format(service.getUptimeForDay())) + "%");
                Messages.get();
                this.addPair(Messages.GeneralInfo_UptimeWeek, String.valueOf(nf.format(service.getUptimeForWeek())) + "%");
                Messages.get();
                this.addPair(Messages.GeneralInfo_UptimeMonth, String.valueOf(nf.format(service.getUptimeForMonth())) + "%");
                break;
            }
            case 30: {
                ServiceCheck tmpl;
                String string;
                ServiceCheck check = (ServiceCheck)object;
                Messages.get();
                if (check.isTemplate()) {
                    Messages.get();
                    string = Messages.GeneralInfo_Yes;
                } else {
                    Messages.get();
                    string = Messages.GeneralInfo_No;
                }
                this.addPair(Messages.GeneralInfo_IsTemplate, string);
                if (check.getTemplateId() == 0L || (tmpl = (ServiceCheck)session.findObjectById(check.getTemplateId(), ServiceCheck.class)) == null) break;
                Messages.get();
                this.addPair(Messages.GeneralInfo_Template, tmpl.getObjectName());
                break;
            }
        }
        if (object.getGeolocation().getType() != 0) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_Location, object.getGeolocation().toString());
        }
        if (!object.getPostalAddress().isEmpty()) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_PostalAddress, object.getPostalAddress().getAddressLine());
        }
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.GeneralInfo_Title;
    }
}

