/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class NXCException
extends Exception {
    private static final long serialVersionUID = 1453981595988661915L;
    protected int errorCode;
    protected String additionalInfo;

    public NXCException(int errorCode) {
        this.errorCode = errorCode;
        this.additionalInfo = null;
    }

    public NXCException(int errorCode, String additionalInfo) {
        this.errorCode = errorCode;
        this.additionalInfo = additionalInfo;
    }

    protected String getErrorMessage(int code2, String lang) {
        try {
            ResourceBundle bundle = PropertyResourceBundle.getBundle("messages", new Locale(lang));
            try {
                return String.format(bundle.getString(String.format("RCC_%04d", code2)), this.additionalInfo);
            }
            catch (MissingResourceException e) {
                return String.format(bundle.getString("RCC_UNKNOWN"), code2);
            }
        }
        catch (Exception e) {
            return "Error " + Integer.toString(code2);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(this.errorCode, "en");
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale2 = Locale.getDefault();
        return this.getErrorMessage(this.errorCode, locale2.getLanguage());
    }
}

