/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class Event {
    private final long id;
    private final int code;
    private final Date timeStamp;
    private final long sourceId;
    private final int severity;
    private final String message;
    private final String userTag;
    private final String[] parameters;

    public Event(NXCPMessage msg, long baseId) {
        long varId = baseId;
        this.id = msg.getFieldAsInt64(varId++);
        this.code = msg.getFieldAsInt32(varId++);
        this.timeStamp = msg.getFieldAsDate(varId++);
        this.sourceId = msg.getFieldAsInt64(varId++);
        this.severity = msg.getFieldAsInt32(varId++);
        this.message = msg.getFieldAsString(varId++);
        this.userTag = msg.getFieldAsString(varId++);
        int count2 = msg.getFieldAsInt32(varId++);
        this.parameters = new String[count2];
        for (int i = 0; i < count2; ++i) {
            this.parameters[i] = msg.getFieldAsString(varId++);
        }
    }

    public long getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public String[] getParameters() {
        return this.parameters;
    }
}

