/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import org.netxms.base.NXCPMessage;
import org.netxms.client.objecttools.InputFieldOptions;
import org.netxms.client.objecttools.InputFieldType;

public class InputField {
    private String name;
    private InputFieldType type;
    private String displayName;
    private InputFieldOptions options;

    public InputField(String name) {
        this.name = name;
        this.type = InputFieldType.TEXT;
        this.displayName = name;
        this.options = new InputFieldOptions();
    }

    public InputField(String name, InputFieldType type, String displayName, String config2) {
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.options = InputFieldOptions.createFromXml(config2);
    }

    public InputField(InputField src) {
        this.name = src.name;
        this.type = src.type;
        this.displayName = src.displayName;
        this.options = new InputFieldOptions(src.options);
    }

    protected InputField(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.type = InputFieldType.getByValue(msg.getFieldAsInt32(baseId + 1L));
        this.displayName = msg.getFieldAsString(baseId + 2L);
        this.options = InputFieldOptions.createFromXml(msg.getFieldAsString(baseId + 3L));
    }

    protected void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setFieldInt16(baseId + 1L, this.type.getValue());
        msg.setField(baseId + 2L, this.displayName);
        msg.setField(baseId + 3L, this.options.createXml());
    }

    public InputFieldType getType() {
        return this.type;
    }

    public void setType(InputFieldType type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public InputFieldOptions getOptions() {
        return this.options;
    }

    public void setOptions(InputFieldOptions options) {
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "InputField [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", displayName=" + this.displayName + "]";
    }
}

