/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.situations;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPMessage;
import org.netxms.client.situations.Situation;

public class SituationInstance {
    private Situation parent;
    private String name;
    private Map<String, String> attributes;

    protected SituationInstance(Situation parent, NXCPMessage msg, long baseId) {
        this.parent = parent;
        this.name = msg.getFieldAsString(baseId);
        int count2 = msg.getFieldAsInt32(baseId + 1L);
        this.attributes = new HashMap<String, String>(count2);
        long varId = baseId + 2L;
        for (int i = 0; i < count2; ++i) {
            String name = msg.getFieldAsString(varId++);
            String value = msg.getFieldAsString(varId++);
            this.attributes.put(name, value);
        }
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Situation getParent() {
        return this.parent;
    }
}

