/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.io.FilterInputStream;
import java.io.IOException;
import net.sf.jasperreports.data.DataFileConnection;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataFileStream
extends FilterInputStream {
    private static final Log log = LogFactory.getLog(DataFileUtils.class);
    private final DataFileConnection connection;

    public DataFileStream(DataFileConnection connection) {
        super(connection.getInputStream());
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean closed = false;
        try {
            super.close();
            closed = true;
        }
        finally {
            try {
                this.connection.dispose();
            }
            catch (RuntimeException e) {
                if (closed) {
                    throw new IOException(e);
                }
                log.warn((Object)("Failed to dispose connection for " + this.connection), (Throwable)e);
            }
        }
    }

    public void dispose() {
        try {
            super.close();
        }
        catch (IOException e) {
            log.warn((Object)("Failed to dispose stream for " + this.connection), (Throwable)e);
        }
        try {
            this.connection.dispose();
        }
        catch (JRRuntimeException e) {
            log.warn((Object)("Failed to dispose connection for " + this.connection), (Throwable)e);
        }
    }
}

