/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.base.Logger;
import org.netxms.base.LoggingFacility;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.StatusLineContributionItem;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.netxms.ui.eclipse.console";
    private static Activator plugin;
    private StatusLineContributionItem statusItemConnection;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SharedIcons.init();
        Logger.setLoggingFacility((LoggingFacility)new LoggingFacility(){

            public void writeLog(int level, String tag, String message, Throwable t) {
                int s;
                switch (level) {
                    case 3: {
                        s = 4;
                        break;
                    }
                    case 2: {
                        s = 2;
                        break;
                    }
                    case 1: {
                        s = 1;
                        break;
                    }
                    default: {
                        s = 0;
                    }
                }
                Activator.log(s, String.valueOf(tag) + ": " + message, t);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public StatusLineContributionItem getStatusItemConnection() {
        return this.statusItemConnection;
    }

    public void setStatusItemConnection(StatusLineContributionItem statusItemConnection) {
        this.statusItemConnection = statusItemConnection;
    }

    public static void showTrayIcon() {
        if (ConsoleSharedData.getTrayIcon() != null) {
            return;
        }
        Tray tray = Display.getDefault().getSystemTray();
        if (tray != null) {
            TrayItem item = new TrayItem(tray, 0);
            Messages.get();
            item.setToolTipText(Messages.Activator_TrayTooltip);
            item.setImage(Activator.getImageDescriptor("icons/launcher/16x16.png").createImage());
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    shell.setVisible(true);
                    shell.setMinimized(false);
                }
            });
            ConsoleSharedData.setTrayIcon(item);
        }
    }

    public static void hideTrayIcon() {
        TrayItem item = ConsoleSharedData.getTrayIcon();
        if (item == null) {
            return;
        }
        ConsoleSharedData.setTrayIcon(null);
        item.dispose();
    }

    public static void logInfo(String msg) {
        Activator.log(1, msg, null);
    }

    public static void logError(String msg, Throwable t) {
        Activator.log(4, msg, t);
    }

    public static void log(int status, String msg, Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(status, PLUGIN_ID, 0, msg, t));
    }
}

