/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.ClusterResource;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditClusterResourceDialog
extends Dialog {
    private ClusterResource resource;
    private LabeledText nameField;
    private LabeledText addressField;
    private String name;
    private InetAddress address;

    public EditClusterResourceDialog(Shell parentShell, ClusterResource resource) {
        super(parentShell);
        this.resource = resource;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.resource != null) {
            Messages.get();
            string = Messages.EditClusterResourceDialog_TitleEdit;
        } else {
            Messages.get();
            string = Messages.EditClusterResourceDialog_TitleCreate;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.nameField.setLabel(Messages.EditClusterResourceDialog_ResName);
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.addressField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.addressField.setLabel(Messages.EditClusterResourceDialog_VIP);
        this.addressField.getTextControl().setTextLimit(32);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.addressField.setLayoutData((Object)gd);
        if (this.resource != null) {
            this.nameField.setText(this.resource.getName());
            this.addressField.setText(this.resource.getVirtualAddress().getHostAddress());
        }
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.address = InetAddress.getByName(this.addressField.getText().trim());
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.EditClusterResourceDialog_Warning, (String)Messages.EditClusterResourceDialog_WarningInvalidIP);
            return;
        }
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.EditClusterResourceDialog_Warning, (String)Messages.EditClusterResourceDialog_WarningEmptyName);
            return;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

