/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.InputFieldOptions;
import org.netxms.client.objecttools.InputFieldType;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditInputFieldDialog
extends Dialog {
    private final String[] typeNames = new String[]{"Text", "Password", "Number"};
    private boolean create;
    private InputField field;
    private LabeledText name;
    private Combo type;
    private LabeledText displayName;
    private Button checkValidatePassword;

    public EditInputFieldDialog(Shell parentShell, boolean create, InputField field) {
        super(parentShell);
        this.create = create;
        this.field = field;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.create ? "Add Input Field" : "Edit Input Field");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.field.getName());
        this.name.setEditable(this.create);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Type", (Object)"WidgetHelper::default_layout_data");
        int i = 0;
        while (i < this.typeNames.length) {
            this.type.add(this.typeNames[i]);
            ++i;
        }
        this.type.select(this.field.getType().getValue());
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditInputFieldDialog.this.checkValidatePassword.setVisible(InputFieldType.getByValue((int)EditInputFieldDialog.this.type.getSelectionIndex()) == InputFieldType.PASSWORD);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.displayName = new LabeledText(dialogArea, 0);
        this.displayName.setLabel("Display name");
        this.displayName.setText(this.field.getDisplayName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.displayName.setLayoutData((Object)gd);
        this.checkValidatePassword = new Button(dialogArea, 32);
        this.checkValidatePassword.setText("Validate password after entry");
        this.checkValidatePassword.setVisible(this.field.getType() == InputFieldType.PASSWORD);
        this.checkValidatePassword.setSelection(this.field.getOptions().validatePassword);
        return dialogArea;
    }

    protected void okPressed() {
        if (this.create) {
            this.field.setName(this.name.getText());
        }
        this.field.setType(InputFieldType.getByValue((int)this.type.getSelectionIndex()));
        this.field.setDisplayName(this.displayName.getText());
        if (this.field.getType() == InputFieldType.PASSWORD) {
            InputFieldOptions o = new InputFieldOptions();
            o.validatePassword = this.checkValidatePassword.getSelection();
            this.field.setOptions(o);
        }
        super.okPressed();
    }
}

