/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.HostSearchResults;

public class FindConnectionPoint
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private long objectId;

    public void run(IAction action) {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.FindConnectionPoint_JobTitle, this.objectId), this.wbPart, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ConnectionPoint cp = session.findConnectionPoint(FindConnectionPoint.this.objectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HostSearchResults.showConnection(cp);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.FindConnectionPoint_JobError;
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Node || obj instanceof Interface || obj instanceof AccessPoint) {
                action.setEnabled(true);
                this.objectId = ((AbstractObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.objectId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.objectId = 0L;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }
}

