/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.widgets.helpers.CellSelectionManager;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableContentProvider;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableItemComparator;
import org.netxms.ui.eclipse.perfview.widgets.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableValue
extends Composite {
    private static long uniqueId = 1L;
    private NXCSession session;
    private IViewPart viewPart;
    private long objectId = 0L;
    private long dciId = 0L;
    private String configId;
    private String objectName = null;
    private Table currentData = null;
    private SortableTableViewer viewer;
    private CLabel errorLabel;
    private CellSelectionManager cellSelectionManager;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public TableValue(Composite parent, int style, IViewPart viewPart, String configId) {
        super(parent, style);
        this.viewPart = viewPart;
        this.configId = configId;
        this.session = ConsoleSharedData.getSession();
        this.setLayout((Layout)new FormLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.cellSelectionManager = new CellSelectionManager(this.viewer);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        Messages.get();
        this.actionShowLineChart = new Action(Messages.TableValue_LineChart, Activator.getImageDescriptor("icons/chart_line.png")){

            public void run() {
                TableValue.this.showLineChart();
            }
        };
        Messages.get();
        this.actionShowBarChart = new Action(Messages.TableValue_BarChart, Activator.getImageDescriptor("icons/chart_bar.png")){

            public void run() {
                TableValue.this.showDataComparisonChart(0);
            }
        };
        Messages.get();
        this.actionShowPieChart = new Action(Messages.TableValue_PieChart, Activator.getImageDescriptor("icons/chart_pie.png")){

            public void run() {
                TableValue.this.showDataComparisonChart(1);
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableValue.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setObject(long objectId, long dciId) {
        this.objectId = objectId;
        this.dciId = dciId;
        this.objectName = this.session.getObjectName(objectId);
    }

    public void refresh(final Runnable postRefreshHook) {
        this.viewer.setInput(null);
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.TableValue_JobName, this.dciId), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableValue.this.session.getTableLastValues(TableValue.this.objectId, TableValue.this.dciId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TableValue.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (TableValue.this.errorLabel != null) {
                            TableValue.this.errorLabel.dispose();
                            TableValue.this.errorLabel = null;
                            TableValue.this.viewer.getControl().setVisible(true);
                            TableValue.this.viewer.getControl().getParent().layout(true, true);
                        }
                        TableValue.this.updateViewer(table);
                        if (postRefreshHook != null) {
                            postRefreshHook.run();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.TableValue_JobError, TableValue.this.dciId);
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TableValue.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (TableValue.this.errorLabel == null) {
                            TableValue.this.errorLabel = new CLabel(TableValue.this.viewer.getControl().getParent(), 0);
                            TableValue.this.errorLabel.setFont(JFaceResources.getBannerFont());
                            TableValue.this.errorLabel.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                            TableValue.this.errorLabel.moveAbove(TableValue.this.viewer.getControl());
                            FormData fd = new FormData();
                            fd.top = new FormAttachment(0, 0);
                            fd.left = new FormAttachment(0, 0);
                            fd.right = new FormAttachment(100, 0);
                            fd.bottom = new FormAttachment(100, 0);
                            TableValue.this.errorLabel.setLayoutData((Object)fd);
                            TableValue.this.viewer.getControl().getParent().layout(true, true);
                            TableValue.this.viewer.getControl().setVisible(false);
                        }
                        TableValue.this.errorLabel.setText(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 150);
            this.viewer.createColumns(names, widths, 0, 128);
            StringBuilder sb = new StringBuilder("TableLastValues.");
            sb.append(this.dciId);
            if (this.configId != null) {
                sb.append('.');
                sb.append(this.configId);
            }
            final String id = sb.toString();
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)id);
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableValue.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)id);
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        ((TableLabelProvider)this.viewer.getLabelProvider()).setColumns(table.getColumns());
        this.viewer.setInput((Object)table);
        this.currentData = table;
    }

    private String buildInstanceString(ViewerRow viewerRow) {
        StringBuilder instance = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < this.currentData.getColumnCount()) {
            TableColumnDefinition cd = this.currentData.getColumnDefinition(i);
            if (cd.isInstanceColumn()) {
                if (!first) {
                    instance.append("~~~");
                }
                instance.append(viewerRow.getText(i));
                first = false;
            }
            ++i;
        }
        return instance.toString();
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = Long.toString(uniqueId++);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableValue.safeEncode(this.currentData.getTitle()) + "@" + TableValue.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValue.safeEncode(instance) + "@" + TableValue.safeEncode(column.getName());
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
        }
        catch (Exception e) {
            Shell shell = page.getWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.TableValue_Error, (String)String.format(Messages.TableValue_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private void showDataComparisonChart(int chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        String id = String.valueOf(Long.toString(uniqueId++)) + "&" + Integer.toString(chartType);
        int i = 0;
        while (i < cells.length) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            int source = this.currentData.getSource();
            id = String.valueOf(id) + "&" + Long.toString(this.objectId) + "@" + Long.toString(this.dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(column.getDataType()) + "@" + TableValue.safeEncode(this.currentData.getTitle()) + "@" + TableValue.safeEncode(String.valueOf(column.getDisplayName()) + ": " + instance.replace("~~~", " / ")) + "@" + TableValue.safeEncode(instance) + "@" + TableValue.safeEncode(column.getName());
            ++i;
        }
        IWorkbenchPage page = this.viewPart != null ? this.viewPart.getSite().getPage() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("org.netxms.ui.eclipse.perfview.views.DataComparisionView", id, 1);
        }
        catch (Exception e) {
            Shell shell = page.getWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.TableValue_Error, (String)String.format(Messages.TableValue_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private static String safeEncode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "none";
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "[" + this.dciId + "]";
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }
}

