/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serviceview.widgets.helpers;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IFigureProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.ui.eclipse.serviceview.Activator;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.IServiceFigureListener;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.ServiceFigure;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.ServiceTreeElement;

public class ServiceTreeLabelProvider
extends LabelProvider
implements IFigureProvider {
    private GraphViewer viewer;
    private IServiceFigureListener figureListener;
    private ILabelProvider workbenchLabelProvider;
    private Font font;
    private Image collapsedIcon;
    private Image expandedIcon;

    public ServiceTreeLabelProvider(GraphViewer viewer, IServiceFigureListener figureListener) {
        this.viewer = viewer;
        this.figureListener = figureListener;
        this.workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.font = new Font((Device)Display.getDefault(), "Verdana", 7, 0);
        this.collapsedIcon = Activator.getImageDescriptor("icons/collapsed.png").createImage();
        this.expandedIcon = Activator.getImageDescriptor("icons/expanded.png").createImage();
    }

    public String getText(Object element) {
        if (element instanceof ServiceTreeElement) {
            return ((ServiceTreeElement)element).getObject().getObjectName();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof ServiceTreeElement) {
            return this.workbenchLabelProvider.getImage((Object)((ServiceTreeElement)element).getObject());
        }
        return null;
    }

    public Font getFont() {
        return this.font;
    }

    public IFigure getFigure(Object element) {
        return new ServiceFigure((ServiceTreeElement)element, this, this.figureListener);
    }

    public Image getExpansionStatusIcon(ServiceTreeElement element) {
        return element.hasChildren() ? (element.isExpanded() ? this.expandedIcon : this.collapsedIcon) : null;
    }

    public void dispose() {
        this.font.dispose();
        this.collapsedIcon.dispose();
        this.expandedIcon.dispose();
        this.workbenchLabelProvider.dispose();
        super.dispose();
    }

    public boolean isElementSelected(ServiceTreeElement element) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? selection.toList().contains(element) : false;
    }
}

