/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.client.MacAddress;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.figures.BirtChartFigure;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.NodeLastValuesFigure;

public class ObjectTooltip
extends Figure {
    private NodeLastValuesFigure lastValuesFigure = null;

    public ObjectTooltip(AbstractObject object, MapLabelProvider labelProvider) {
        DciValue[] values;
        MacAddress mac;
        StringBuilder sb;
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)layout);
        Label title = new Label();
        title.setIcon(labelProvider.getWorkbenchIcon(object));
        title.setText(object.getObjectName());
        title.setFont(JFaceResources.getBannerFont());
        this.add((IFigure)title);
        Label status = new Label();
        status.setIcon(StatusDisplayInfo.getStatusImage((ObjectStatus)object.getStatus()));
        status.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        this.add((IFigure)status);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.setConstraint((IFigure)status, gd);
        if (object instanceof Node && !((Node)object).getPrimaryIP().isAnyLocalAddress()) {
            sb = new StringBuilder(((Node)object).getPrimaryIP().getHostAddress());
            mac = ((Node)object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
            Label iface = new Label();
            iface.setIcon(SharedIcons.IMG_IP_ADDRESS);
            iface.setText(sb.toString());
            this.add((IFigure)iface);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)iface, gd);
        }
        if (object instanceof Node && (values = labelProvider.getNodeLastValues(object.getObjectId())) != null && values.length > 0) {
            this.lastValuesFigure = new NodeLastValuesFigure(values);
            this.add((IFigure)this.lastValuesFigure);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)this.lastValuesFigure, gd);
        }
        if (object instanceof Container) {
            this.addStatusChart(object, labelProvider);
        }
        if (object instanceof AccessPoint) {
            sb = new StringBuilder(((AccessPoint)object).getModel());
            mac = ((AccessPoint)object).getMacAddress();
            if (mac != null) {
                sb.append('\n');
                sb.append(mac.toString());
            }
            RadioInterface[] radioInterfaceArray = ((AccessPoint)object).getRadios();
            int n = radioInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RadioInterface rif = radioInterfaceArray[n2];
                Messages.get();
                sb.append(Messages.ObjectTooltip_Radio);
                sb.append(rif.getIndex());
                sb.append(" (");
                sb.append(rif.getMacAddress().toString());
                Messages.get();
                sb.append(Messages.ObjectTooltip_Channel);
                sb.append(rif.getChannel());
                Messages.get();
                sb.append(Messages.ObjectTooltip_TXPower);
                sb.append(rif.getPowerMW());
                Messages.get();
                sb.append(Messages.ObjectTooltip_mW);
                ++n2;
            }
            Label info = new Label();
            info.setText(sb.toString());
            this.add((IFigure)info);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)info, gd);
        }
        if (!object.getComments().isEmpty()) {
            FlowPage page = new FlowPage();
            this.add((IFigure)page);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)page, gd);
            TextFlow text = new TextFlow();
            text.setText("\n" + object.getComments());
            page.add((IFigure)text);
        }
    }

    private void addStatusChart(AbstractObject object, MapLabelProvider labelProvider) {
        BirtChartFigure chart = new BirtChartFigure(0, labelProvider.getColors());
        this.add((IFigure)chart);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.heightHint = 180;
        gd.widthHint = 320;
        this.setConstraint((IFigure)chart, gd);
        int[] objectCount = new int[6];
        this.collectData(objectCount, object);
        chart.setTitleVisible(true);
        Messages.get();
        chart.setChartTitle(Messages.ObjectTooltip_ChartTitle);
        chart.setLegendPosition(2);
        chart.setLegendVisible(true);
        chart.set3DModeEnabled(true);
        chart.setTransposed(false);
        chart.setTranslucent(false);
        chart.setBorder((Border)new LineBorder());
        int i = 0;
        while (i <= ObjectStatus.UNKNOWN.getValue()) {
            chart.addParameter(new GraphItem(0L, 0L, 0, 0, StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i)), (double)objectCount[i]);
            chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        chart.initializationComplete();
    }

    private void collectData(int[] objectCount, AbstractObject root) {
        for (AbstractObject o : root.getAllChilds(2)) {
            if (o.getStatus().compareTo((Enum)ObjectStatus.UNKNOWN) > 0) continue;
            int n = o.getStatus().getValue();
            objectCount[n] = objectCount[n] + 1;
        }
    }
}

