/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.text.NumberFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.base.NXCPMessage;

public class GeoLocation {
    private static final double ROUND_OFF = 1.0E-8;
    public static final int UNSET = 0;
    public static final int MANUAL = 1;
    public static final int GPS = 2;
    public static final int NETWORK = 3;
    private int type;
    private double latitude;
    private double longitude;
    private int accuracy;
    private Date timestamp;
    private Date endTimestamp;

    public GeoLocation(NXCPMessage msg) {
        this.type = msg.getFieldAsInt32(342L);
        this.latitude = msg.getFieldAsDouble(343L);
        this.longitude = msg.getFieldAsDouble(344L);
        this.accuracy = msg.getFieldAsInt32(438L);
        this.timestamp = msg.getFieldAsDate(439L);
    }

    public GeoLocation(long base2, NXCPMessage msg) {
        this.type = 0;
        this.latitude = msg.getFieldAsDouble(base2);
        this.longitude = msg.getFieldAsDouble(base2 + 1L);
        this.accuracy = msg.getFieldAsInt32(base2 + 2L);
        this.timestamp = msg.getFieldAsDate(base2 + 3L);
        this.endTimestamp = msg.getFieldAsDate(base2 + 4L);
    }

    public GeoLocation(boolean isGPS) {
        this.type = isGPS ? 2 : 0;
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.accuracy = 0;
    }

    public GeoLocation(double lat, double lon) {
        this.type = 1;
        this.latitude = lat;
        this.longitude = lon;
        this.accuracy = 0;
    }

    public GeoLocation(double lat, double lon, int type, int accuracy, Date timestamp) {
        this.type = type;
        this.latitude = lat;
        this.longitude = lon;
        this.accuracy = accuracy;
        this.timestamp = timestamp;
    }

    public boolean isAutomatic() {
        return this.type == 2 || this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    private static int getIntegerDegree(double pos) {
        return (int)(Math.abs(pos) + 1.0E-8);
    }

    private static int getIntegerMinutes(double pos) {
        double d = Math.abs(pos) + 1.0E-8;
        return (int)((d - (double)((int)d)) * 60.0);
    }

    private static double getDecimalSeconds(double pos) {
        double d = Math.abs(pos) * 60.0 + 1.0E-8;
        return (d - (double)((int)d)) * 60.0;
    }

    private static String posToText(double pos, boolean isLat) {
        if (pos < -180.0 || pos > 180.0) {
            return "<invalid>";
        }
        StringBuilder sb = new StringBuilder();
        if (isLat) {
            sb.append(pos < 0.0 ? (char)'S' : 'N');
        } else {
            sb.append(pos < 0.0 ? (char)'W' : 'E');
        }
        sb.append(' ');
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        sb.append(nf.format(GeoLocation.getIntegerDegree(pos)));
        sb.append("\u00b0 ");
        sb.append(nf.format(GeoLocation.getIntegerMinutes(pos)));
        sb.append("' ");
        nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        sb.append(nf.format(GeoLocation.getDecimalSeconds(pos)));
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        if (this.accuracy > 0) {
            return GeoLocation.posToText(this.latitude, true) + " " + GeoLocation.posToText(this.longitude, false) + " (accuracy " + this.accuracy + " meters)";
        }
        return GeoLocation.posToText(this.latitude, true) + " " + GeoLocation.posToText(this.longitude, false);
    }

    public static String latitudeToString(double lat) {
        return GeoLocation.posToText(lat, true);
    }

    public static String longitudeToString(double lon) {
        return GeoLocation.posToText(lon, false);
    }

    public String getLatitudeAsString() {
        return GeoLocation.posToText(this.latitude, true);
    }

    public String getLongitudeAsString() {
        return GeoLocation.posToText(this.longitude, false);
    }

    private static double parse(String str, boolean isLat) throws GeoLocationFormatException {
        String in = str.trim();
        try {
            double value = Double.parseDouble(str);
            if (value < -180.0 || value > 180.0) {
                throw new GeoLocationFormatException();
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            Pattern p = Pattern.compile((isLat ? "([NS]*)" : "([EW]*)") + "\\s*([0-9]+(?:[.,][0-9]+)*)\u00b0?\\s*([0-9]+(?:[.,][0-9]+)*)?\\'?\\s*([0-9]+(?:[.,][0-9]+)*)?\\\"?\\s*" + (isLat ? "([NS]*)" : "([EW]*)"));
            Matcher m = p.matcher(in);
            if (m.matches()) {
                char ch;
                if (m.group(1) != null && m.group(1).length() > 0) {
                    ch = m.group(1).charAt(0);
                } else if (m.group(5) != null && m.group(5).length() > 0) {
                    ch = m.group(5).charAt(0);
                } else {
                    throw new GeoLocationFormatException();
                }
                int sign = ch == 'N' || ch == 'E' ? 1 : -1;
                try {
                    double deg = Double.parseDouble(m.group(2).replace(',', '.'));
                    double min = m.group(3) != null ? Double.parseDouble(m.group(3).replace(',', '.')) : 0.0;
                    double sec = m.group(4) != null ? Double.parseDouble(m.group(4).replace(',', '.')) : 0.0;
                    double value = (double)sign * (deg + min / 60.0 + sec / 3600.0);
                    if (value < -180.0 || value > 180.0) {
                        throw new GeoLocationFormatException();
                    }
                    return value;
                }
                catch (NumberFormatException e) {
                    throw new GeoLocationFormatException();
                }
            }
            throw new GeoLocationFormatException();
        }
    }

    public static GeoLocation parseGeoLocation(String lat, String lon) throws GeoLocationFormatException {
        double _lat = GeoLocation.parse(lat, true);
        double _lon = GeoLocation.parse(lon, false);
        return new GeoLocation(_lat, _lon);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(Date endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.accuracy;
        result2 = 31 * result2 + (this.endTimestamp == null ? 0 : this.endTimestamp.hashCode());
        long temp = Double.doubleToLongBits(this.latitude);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result2 = 31 * result2 + this.type;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoLocation other = (GeoLocation)obj;
        if (this.accuracy != other.accuracy) {
            return false;
        }
        if (this.endTimestamp == null ? other.endTimestamp != null : !this.endTimestamp.equals(other.endTimestamp)) {
            return false;
        }
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return this.type == other.type;
    }
}

