/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class ColumnFilter {
    public static final int EQUALS = 0;
    public static final int RANGE = 1;
    public static final int SET = 2;
    public static final int LIKE = 3;
    public static final int LESS = 4;
    public static final int GREATER = 5;
    public static final int CHILDOF = 6;
    public static final int AND = 0;
    public static final int OR = 1;
    private int type;
    private long rangeFrom;
    private long rangeTo;
    private long numericValue;
    private String like;
    private HashSet<ColumnFilter> set;
    private int operation;
    private boolean negated = false;

    public ColumnFilter(int type, long value) {
        this.type = type;
        this.numericValue = value;
    }

    public ColumnFilter(long rangeFrom, long rangeTo) {
        this.type = 1;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
    }

    public ColumnFilter(String value) {
        this.type = 3;
        this.like = value;
    }

    public ColumnFilter() {
        this.type = 2;
        this.set = new HashSet();
        this.operation = 0;
    }

    public void addSubFilter(ColumnFilter filter) {
        if (this.type == 2) {
            this.set.add(filter);
        }
    }

    int fillMessage(NXCPMessage msg, long baseId) {
        int varCount = 1;
        msg.setFieldInt16(baseId, this.type);
        switch (this.type) {
            case 0: 
            case 4: 
            case 5: 
            case 6: {
                msg.setFieldInt64(baseId + 1L, this.numericValue);
                msg.setFieldInt16(baseId + 2L, this.negated ? 1 : 0);
                varCount += 2;
                break;
            }
            case 1: {
                msg.setFieldInt64(baseId + 1L, this.rangeFrom);
                msg.setFieldInt64(baseId + 2L, this.rangeTo);
                msg.setFieldInt16(baseId + 3L, this.negated ? 1 : 0);
                varCount += 3;
                break;
            }
            case 3: {
                msg.setField(baseId + 1L, this.like);
                msg.setFieldInt16(baseId + 2L, this.negated ? 1 : 0);
                varCount += 2;
                break;
            }
            case 2: {
                msg.setFieldInt16(baseId + 1L, this.operation);
                msg.setFieldInt16(baseId + 2L, this.set.size());
                varCount += 2;
                long varId = baseId + 3L;
                for (ColumnFilter f : this.set) {
                    int count2 = f.fillMessage(msg, varId);
                    varId += (long)count2;
                    varCount += count2;
                }
                break;
            }
        }
        return varCount;
    }

    public long getRangeFrom() {
        return this.rangeFrom;
    }

    public void setRangeFrom(long rangeFrom) {
        this.rangeFrom = rangeFrom;
    }

    public long getRangeTo() {
        return this.rangeTo;
    }

    public void setRangeTo(long rangeTo) {
        this.rangeTo = rangeTo;
    }

    public long getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(long numericValue) {
        this.numericValue = numericValue;
    }

    public String getLike() {
        return this.like;
    }

    public void setLike(String like) {
        this.like = like;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getType() {
        return this.type;
    }

    public Set<ColumnFilter> getSubFilters() {
        return this.set;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }
}

