/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.w3c.dom.Node;

public class ContentRequestMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();

    protected ContentRequestMatchers() {
    }

    public RequestMatcher contentType(String expectedContentType) {
        return this.contentType(MediaType.parseMediaType((String)expectedContentType));
    }

    public RequestMatcher contentType(final MediaType expectedContentType) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MediaType actualContentType = request.getHeaders().getContentType();
                AssertionErrors.assertTrue("Content type not set", actualContentType != null);
                AssertionErrors.assertEquals("Content type", expectedContentType, actualContentType);
            }
        };
    }

    public RequestMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)contentType));
    }

    public RequestMatcher contentTypeCompatibleWith(final MediaType contentType) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MediaType actualContentType = request.getHeaders().getContentType();
                AssertionErrors.assertTrue("Content type not set", actualContentType != null);
                AssertionErrors.assertTrue("Content type [" + actualContentType + "] is not compatible with [" + contentType + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public RequestMatcher string(final Matcher<? super String> matcher) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                MatcherAssert.assertThat((String)"Request content", (Object)mockRequest.getBodyAsString(), (Matcher)matcher);
            }
        };
    }

    public RequestMatcher string(final String expectedContent) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsString());
            }
        };
    }

    public RequestMatcher bytes(final byte[] expectedContent) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsBytes());
            }
        };
    }

    public RequestMatcher xml(final String expectedXmlContent) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertXmlEqual(expectedXmlContent, request.getBodyAsString());
            }
        };
    }

    public RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertNode(request.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public RequestMatcher source(final Matcher<? super Source> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertSource(request.getBodyAsString(), (Matcher<? super Source>)matcher);
            }
        };
    }

    private static abstract class AbstractXmlRequestMatcher
    implements RequestMatcher {
        private AbstractXmlRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Failed to parse expected or actual XML request content: " + e.getMessage()));
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

