/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImageConverter
extends ElementConverter {
    private static final Log log = LogFactory.getLog(ImageConverter.class);
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage image = (JRImage)element;
        this.copyGraphicElement(reportConverter, image, printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalImageAlign(image.getOwnHorizontalImageAlign());
        printImage.setLazy(image.isLazy());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setVerticalImageAlign(image.getOwnVerticalImageAlign());
        printImage.setRenderable(this.getRenderable(reportConverter.getJasperReportsContext(), image, printImage));
        printImage.setScaleImage(image.getOwnScaleImageValue());
        return printImage;
    }

    private Renderable getRenderable(JasperReportsContext jasperReportsContext, JRImage imageElement, JRPrintImage printImage) {
        block8: {
            block7: {
                String location = JRExpressionUtil.getSimpleExpressionText(imageElement.getExpression());
                if (location != null) {
                    try {
                        return RenderableUtil.getInstance(jasperReportsContext).getRenderable(location);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) break block7;
                        log.debug((Object)"Creating location renderer for converted image failed.", (Throwable)e);
                    }
                }
            }
            try {
                printImage.setScaleImage(ScaleImageEnum.CLIP);
                return RenderableUtil.getInstance(jasperReportsContext).getRenderable("net/sf/jasperreports/engine/images/image-16.png", imageElement.getOnErrorTypeValue());
            }
            catch (JRException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating icon renderer for converted image failed.", (Throwable)e);
                }
            }
            catch (JRRuntimeException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"Creating icon renderer for converted image failed.", (Throwable)e);
            }
        }
        return null;
    }
}

