/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.objecttabs;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesWidget;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class LastValues
extends ObjectTab {
    private LastValuesWidget dataView;

    protected void createTabContent(Composite parent) {
        this.dataView = new LastValuesWidget(this.getViewPart(), parent, 0, this.getObject(), "LastValuesTab", new VisibilityValidator(){

            public boolean isVisible() {
                return LastValues.this.isActive();
            }
        });
        this.dataView.setAutoRefreshEnabled(true);
        this.dataView.setFilterCloseAction(new Action(){

            public void run() {
                LastValues.this.dataView.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
                State state = command.getState("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
    }

    public void objectChanged(AbstractObject object) {
        this.dataView.setDataCollectionTarget(object);
        if (this.getViewPart().getSite().getPage().isPartVisible((IWorkbenchPart)this.getViewPart()) && this.isActive()) {
            this.dataView.refresh();
        }
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof Node || object instanceof MobileDevice || object instanceof Cluster;
    }

    public void refresh() {
        this.dataView.refresh();
    }

    public void setFilterEnabled(boolean enabled) {
        this.dataView.enableFilter(enabled);
    }

    public void selected() {
        super.selected();
        IContextService contextService = (IContextService)this.getViewPart().getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
        this.refresh();
    }
}

