/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.AddUsmCredDialog;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpConfig;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpUsmComparator;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpUsmLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.StringComparator;

public class SnmpCredentials
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.SnmpCredentials";
    private NXCSession session;
    private boolean modified = false;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TableViewer snmpCommunityList;
    private TableViewer snmpUsmCredList;
    private TableViewer snmpPortList;
    private Action actionSave;
    private SnmpConfig config;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("SNMP Configuration");
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createSnmpCommunitySection();
        this.createSnmpUsmCredSection();
        this.createSnmpPortList();
        this.createActions();
        this.contributeToActionBars();
        new ConsoleJob("Loading SNMP configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final SnmpConfig loadedConfig = SnmpConfig.load(SnmpCredentials.this.session);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SnmpCredentials.this.setConfig(loadedConfig);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error while loading SNMP configuration";
            }
        }.start();
    }

    private void createActions() {
        Messages.get();
        this.actionSave = new Action(Messages.SnmpConfigurator_Save, SharedIcons.SAVE){

            public void run() {
                SnmpCredentials.this.save();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void createSnmpCommunitySection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.SnmpConfigurator_SectionCommunities);
        Messages.get();
        section.setDescription(Messages.SnmpConfigurator_SectionCommunitiesDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.snmpCommunityList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.snmpCommunityList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 150;
        this.snmpCommunityList.getTable().setLayoutData((Object)gd);
        this.snmpCommunityList.getTable().setSortDirection(128);
        this.snmpCommunityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpCommunityList.setComparator((ViewerComparator)new StringComparator());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.addCommunity();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.removeCommunity();
            }
        });
    }

    private void createSnmpUsmCredSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        Messages.get();
        section.setText(Messages.SnmpConfigurator_SectionUSM);
        Messages.get();
        section.setDescription(Messages.SnmpConfigurator_SectionUSMDescr);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.snmpUsmCredList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.snmpUsmCredList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 150;
        this.snmpUsmCredList.getTable().setLayoutData((Object)gd);
        this.snmpUsmCredList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpUsmCredList.setLabelProvider((IBaseLabelProvider)new SnmpUsmLabelProvider());
        this.snmpUsmCredList.setComparator((ViewerComparator)new SnmpUsmComparator());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.addUsmCredentials();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.removeUsmCredentials();
            }
        });
    }

    private void createSnmpPortList() {
        Section section = this.toolkit.createSection(this.form.getBody(), 384);
        section.setText("SNMP Ports");
        section.setDescription("SNMP ports used in the network");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.snmpPortList = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.snmpPortList.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 150;
        this.snmpPortList.getTable().setLayoutData((Object)gd);
        this.snmpPortList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpPortList.setComparator((ViewerComparator)new StringComparator());
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.addSnmpPort();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SnmpCredentials.this.removeSnmpPort();
            }
        });
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void setConfig(SnmpConfig config) {
        this.config = config;
        this.snmpCommunityList.setInput((Object)config.getCommunities().toArray());
        this.snmpUsmCredList.setInput((Object)config.getUsmCredentials().toArray());
        this.snmpPortList.setInput((Object)config.getPorts().toArray());
        this.modified = false;
        this.firePropertyChange(257);
    }

    private void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.config.save(this.session);
        }
        catch (Exception e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.SnmpConfigurator_Error, (String)String.format("Cannot save SNMP configuration: %s", e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void save() {
        new ConsoleJob("Save SNMP Configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SnmpCredentials.this.config.save(SnmpCredentials.this.session);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SnmpCredentials.this.modified = false;
                        SnmpCredentials.this.firePropertyChange(257);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error while saving SNMP configuration";
            }
        }.start();
    }

    private void addCommunity() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.SnmpConfigurator_AddCommunity, Messages.SnmpConfigurator_AddCommunityDescr, "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            List<String> list = this.config.getCommunities();
            if (!list.contains(s)) {
                list.add(s);
                this.snmpCommunityList.setInput((Object)list.toArray());
                this.setModified();
            }
        }
    }

    private void removeCommunity() {
        List<String> list = this.config.getCommunities();
        IStructuredSelection selection = (IStructuredSelection)this.snmpCommunityList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpCommunityList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void addUsmCredentials() {
        AddUsmCredDialog dlg = new AddUsmCredDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getValue();
            List<SnmpUsmCredential> list = this.config.getUsmCredentials();
            if (!list.contains(cred)) {
                list.add(cred);
                this.snmpUsmCredList.setInput((Object)list.toArray());
                this.setModified();
            }
        }
    }

    private void removeUsmCredentials() {
        List<SnmpUsmCredential> list = this.config.getUsmCredentials();
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpUsmCredList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void addSnmpPort() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Add SNMP Port", "Please enter SNMP Port", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            List<String> list = this.config.getPorts();
            if (!list.contains(value)) {
                list.add(value);
                this.snmpPortList.setInput((Object)list.toArray());
                this.setModified();
            }
        }
    }

    private void removeSnmpPort() {
        List<String> list = this.config.getPorts();
        IStructuredSelection selection = (IStructuredSelection)this.snmpPortList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpPortList.setInput((Object)list.toArray());
            this.setModified();
        }
    }
}

