/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.ChartConfig;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.PredefinedChartConfig;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.TimePeriodSelector;

public class General
extends PropertyPage {
    private ChartConfig config;
    private LabeledText title;
    private Button checkShowGrid;
    private Button checkShowLegend;
    private Button checkShowHostNames;
    private Button checkAutoRefresh;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkExtendedLegend;
    private Button checkTranslucent;
    private Combo legendPleace;
    private Scale refreshIntervalScale;
    private Spinner refreshIntervalSpinner;
    private TimePeriodSelector timeSelector;
    private YAxisRangeEditor yAxisRange;

    protected Control createContents(Composite parent) {
        this.config = (ChartConfig)this.getElement().getAdapter(ChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0, 2048);
        Messages.get();
        this.title.setLabel(Messages.General_Title);
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.General_Options);
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.verticalSpacing = 4;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.checkShowGrid = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowGrid.setText(Messages.General_ShowGridLines);
        this.checkShowGrid.setSelection(this.config.isShowGrid());
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkLogScale.setText(Messages.General_LogScale);
        this.checkLogScale.setSelection(this.config.isLogScale());
        this.checkStacked = new Button((Composite)optionsGroup, 32);
        this.checkStacked.setText("Stacked");
        this.checkStacked.setSelection(this.config.isStacked());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText("Translucent");
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        Composite legendGroup = new Composite((Composite)optionsGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        legendGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        legendGroup.setLayoutData((Object)gd);
        this.checkShowLegend = new Button(legendGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.General_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        this.checkShowLegend.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.checkExtendedLegend.setEnabled(General.this.checkShowLegend.getSelection());
                General.this.legendPleace.setEnabled(General.this.checkShowLegend.getSelection());
                General.this.checkShowHostNames.setEnabled(General.this.checkShowLegend.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkShowHostNames = new Button(legendGroup, 32);
        Messages.get();
        this.checkShowHostNames.setText(Messages.General_ShowHostNames);
        this.checkShowHostNames.setSelection(this.config.isShowHostNames());
        this.checkShowHostNames.setEnabled(this.config.isShowLegend());
        this.checkExtendedLegend = new Button(legendGroup, 32);
        this.checkExtendedLegend.setText("Show extended legend");
        this.checkExtendedLegend.setSelection(this.config.isExtendedLegend());
        this.checkExtendedLegend.setEnabled(this.config.isShowLegend());
        Composite placeGroup = new Composite((Composite)optionsGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        placeGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        placeGroup.setLayoutData((Object)gd);
        Label comboLabel = new Label(placeGroup, 0);
        comboLabel.setText("Place on ");
        this.legendPleace = new Combo(placeGroup, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.legendPleace.setLayoutData((Object)gridData);
        this.legendPleace.add("left");
        this.legendPleace.add("right");
        this.legendPleace.add("top");
        this.legendPleace.add("bottom");
        this.legendPleace.select(31 - Integer.numberOfLeadingZeros(this.config.getLegendPosition()));
        this.legendPleace.setEnabled(this.config.isShowLegend());
        Composite refreshGroup = new Composite((Composite)optionsGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshGroup.setLayoutData((Object)gd);
        this.checkAutoRefresh = new Button(refreshGroup, 32);
        Messages.get();
        this.checkAutoRefresh.setText(Messages.General_Autorefresh);
        this.checkAutoRefresh.setSelection(this.config.isAutoRefresh());
        this.checkAutoRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.refreshIntervalSpinner.setEnabled(General.this.checkAutoRefresh.getSelection());
                General.this.refreshIntervalScale.setEnabled(General.this.checkAutoRefresh.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite refreshIntervalGroup = new Composite(refreshGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshIntervalGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshIntervalGroup.setLayoutData((Object)gd);
        Label label = new Label(refreshIntervalGroup, 0);
        Messages.get();
        label.setText(Messages.General_RefreshInterval);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.refreshIntervalScale = new Scale(refreshIntervalGroup, 256);
        this.refreshIntervalScale.setMinimum(1);
        this.refreshIntervalScale.setMaximum(600);
        this.refreshIntervalScale.setSelection(this.config.getRefreshRate());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshIntervalScale.setLayoutData((Object)gd);
        this.refreshIntervalScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.refreshIntervalSpinner.setSelection(General.this.refreshIntervalScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.refreshIntervalScale.setEnabled(this.config.isAutoRefresh());
        this.refreshIntervalSpinner = new Spinner(refreshIntervalGroup, 2048);
        this.refreshIntervalSpinner.setMinimum(1);
        this.refreshIntervalSpinner.setMaximum(600);
        this.refreshIntervalSpinner.setSelection(this.config.getRefreshRate());
        this.refreshIntervalSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.refreshIntervalScale.setSelection(General.this.refreshIntervalSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.refreshIntervalSpinner.setEnabled(this.config.isAutoRefresh());
        this.timeSelector = new TimePeriodSelector(dialogArea, 0, this.config.timePeriod());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeSelector.setLayoutData((Object)gd);
        this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yAxisRange.setLayoutData(gd);
        this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        return dialogArea;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.title.setText("");
        this.checkShowGrid.setSelection(true);
        this.checkShowLegend.setSelection(true);
        this.checkShowHostNames.setSelection(false);
        this.checkAutoRefresh.setSelection(true);
        this.checkLogScale.setSelection(false);
        this.checkStacked.setSelection(false);
        this.checkExtendedLegend.setSelection(false);
        this.legendPleace.select(3);
        this.yAxisRange.setSelection(true, 0, 100);
        this.refreshIntervalScale.setSelection(30);
        this.refreshIntervalSpinner.setSelection(30);
        this.timeSelector.setDefaults();
    }

    protected void applyChanges(boolean isApply) {
        this.config.setTitle(this.title.getText());
        this.config.setShowGrid(this.checkShowGrid.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setAutoScale(this.yAxisRange.isAuto());
        this.config.setShowHostNames(this.checkShowHostNames.getSelection());
        this.config.setAutoRefresh(this.checkAutoRefresh.getSelection());
        this.config.setLogScale(this.checkLogScale.getSelection());
        this.config.setRefreshRate(this.refreshIntervalSpinner.getSelection());
        this.config.setStacked(this.checkStacked.getSelection());
        this.config.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.config.setLegendPosition((int)Math.pow(2.0, this.legendPleace.getSelectionIndex()));
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setTimeFrameType(this.timeSelector.getTimeFrameType());
        this.config.setTimeUnits(this.timeSelector.getTimeUnitValue());
        this.config.setTimeRange(this.timeSelector.getTimeRangeValue());
        this.config.setTimeFrom(this.timeSelector.getTimeFrom());
        this.config.setTimeTo(this.timeSelector.getTimeTo());
        this.config.setMinYScaleValue(this.yAxisRange.getMinY());
        this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
        if (this.config instanceof PredefinedChartConfig && isApply) {
            this.setValid(false);
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.General_JobName, null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.saveGraph(((PredefinedChartConfig)General.this.config).createServerSettings(), true);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            General.this.setValid(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.General_JobError;
                }
            }.start();
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

