/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class BindObjectTo
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private Set<Long> objects;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.shell, null, ObjectSelectionDialog.createContainerSelectionFilter());
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            final Long[] childIdList = this.objects.toArray(new Long[this.objects.size()]);
            Messages.get();
            new ConsoleJob(Messages.BindObject_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectmanager", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.BindObject_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    List objects = dlg.getSelectedObjects();
                    for (AbstractObject parent : objects) {
                        Long[] longArray = childIdList;
                        int n = childIdList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Long childId = longArray[n2];
                            session.bindObject(parent.getObjectId(), childId.longValue());
                            ++n2;
                        }
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            this.objects = new HashSet<Long>();
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof AbstractNode) && !(o instanceof Subnet) && !(o instanceof MobileDevice) && !(o instanceof Rack) && !(o instanceof Cluster)) continue;
                this.objects.add(((AbstractObject)o).getObjectId());
            }
        } else {
            action.setEnabled(false);
            this.objects = null;
        }
    }
}

