/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.preference.IPreferenceStore;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RegionalSettings {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    private static int dateTimeFormat = 0;
    private static String dateFormatString;
    private static String timeFormatString;
    private static String shortTimeFormatString;

    public static void updateFromPreferences() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        dateTimeFormat = ps.getInt("DATETIME_FORMAT");
        dateFormatString = ps.getString("DATE_FORMAT_STRING");
        timeFormatString = ps.getString("TIME_FORMAT_STRING");
        shortTimeFormatString = ps.getString("SHORT_TIME_FORMAT_STRING");
        if (ps.getBoolean("USE_SERVER_TIMEZONE")) {
            ConsoleSharedData.setServerTimeZone();
        } else {
            ConsoleSharedData.resetTimeZone();
        }
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = ConsoleSharedData.getSession();
                df = new SimpleDateFormat(String.valueOf(session.getDateFormat()) + " " + session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(String.valueOf(dateFormatString) + " " + timeFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    df = DateFormat.getDateTimeInstance(3, 2);
                }
                break;
            }
            default: {
                df = DateFormat.getDateTimeInstance(3, 2);
            }
        }
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = ConsoleSharedData.getSession();
                df = new SimpleDateFormat(session.getDateFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(dateFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    df = DateFormat.getDateInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getDateInstance(3);
            }
        }
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = ConsoleSharedData.getSession();
                df = new SimpleDateFormat(session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(timeFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    df = DateFormat.getTimeInstance(2);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(2);
            }
        }
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getShortTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = ConsoleSharedData.getSession();
                df = new SimpleDateFormat(session.getShortTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(shortTimeFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    df = DateFormat.getTimeInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(3);
            }
        }
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static String formatTimeDifference(Date start, boolean showSeconds) {
        int hours;
        StringBuilder sb = new StringBuilder();
        int seconds = (int)((System.currentTimeMillis() - start.getTime()) / 1000L);
        int days = seconds / 86400;
        if (days > 0) {
            sb.append(days);
            sb.append(" days, ");
            seconds -= days * 86400;
        }
        if ((hours = seconds / 3600) < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int minutes = (seconds -= hours * 3600) / 60;
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        if (showSeconds) {
            sb.append(':');
            if ((seconds %= 60) < 10) {
                sb.append('0');
            }
            sb.append(seconds);
        }
        return sb.toString();
    }
}

