/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.netxms.client.MacAddress;
import org.netxms.client.MacAddressFormatException;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class MacAddressValidator
implements TextFieldValidator {
    private boolean allowEmpty;

    public MacAddressValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    @Override
    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        try {
            MacAddress.parseMacAddress((String)text);
            return true;
        }
        catch (MacAddressFormatException macAddressFormatException) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(String text, String label) {
        Messages.get();
        return String.format(Messages.MacAddressValidator_ErrorMessage, label);
    }
}

