/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.views.helpers.AbstractTraceViewFilter;
import org.netxms.ui.eclipse.widgets.FilterText;

public abstract class AbstractTraceWidget
extends Composite {
    private static final int MAX_ELEMENTS = 1000;
    private IViewPart viewPart;
    private FilterText filterText;
    private TableViewer viewer;
    private List<Object> data = new ArrayList<Object>(1000);
    private AbstractTraceViewFilter filter = null;
    private boolean paused = false;
    private boolean filterEnabled = false;
    private Action actionPause;
    private Action actionShowFilter;
    private Action actionCopy;

    public AbstractTraceWidget(Composite parent, int style, IViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractTraceWidget.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                AbstractTraceWidget.this.enableFilter(false);
                AbstractTraceWidget.this.actionShowFilter.setChecked(false);
            }
        });
        this.viewer = new TableViewer((Composite)this, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setupViewer(this.viewer);
        WidgetHelper.restoreColumnSettings(this.viewer.getTable(), this.getDialogSettings(), this.getConfigPrefix());
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings(AbstractTraceWidget.this.viewer.getTable(), AbstractTraceWidget.this.getDialogSettings(), AbstractTraceWidget.this.getConfigPrefix());
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData(fd);
        this.createActions();
        this.createPopupMenu();
        this.enableFilter(this.filterEnabled);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractTraceWidget.this.saveConfig();
            }
        });
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Messages.get();
        this.actionPause = new Action(Messages.AbstractTraceView_Pause, 2){

            public void run() {
                AbstractTraceWidget.this.setPaused(AbstractTraceWidget.this.actionPause.isChecked());
            }
        };
        this.actionPause.setImageDescriptor(Activator.getImageDescriptor("icons/pause.png"));
        this.actionPause.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.pause_trace");
        ActionHandler pauseHandler = new ActionHandler((IAction)this.actionPause);
        handlerService.activateHandler(this.actionPause.getActionDefinitionId(), (IHandler)pauseHandler);
        Messages.get();
        this.actionShowFilter = new Action(Messages.AbstractTraceView_ShowFilter, 2){

            public void run() {
                AbstractTraceWidget.this.enableFilter(AbstractTraceWidget.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.show_trace_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        Messages.get();
        this.actionCopy = new Action(Messages.AbstractTraceView_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                AbstractTraceWidget.this.copySelectionToClipboard();
            }
        };
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractTraceWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    protected abstract void setupViewer(TableViewer var1);

    protected void addColumn(String name, int width) {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(name);
        tc.setWidth(width);
    }

    protected void addElement(Object element) {
        if (this.data.size() == 1000) {
            this.data.remove(this.data.size() - 1);
        }
        this.data.add(0, element);
        if (!this.paused) {
            this.viewer.setInput((Object)this.data.toArray());
        }
    }

    public void clear() {
        this.data.clear();
        this.viewer.setInput((Object)new Object[0]);
    }

    protected void refresh() {
        this.viewer.refresh();
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.viewer.setInput((Object)this.data.toArray());
        }
    }

    protected abstract IDialogSettings getDialogSettings();

    protected abstract String getConfigPrefix();

    protected void saveConfig() {
    }

    protected void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout(true, true);
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    protected void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        if (this.filter != null) {
            this.filter.setFilterString(text);
            this.viewer.refresh(false);
        }
    }

    protected void setFilter(AbstractTraceViewFilter filter) {
        if (this.filter != null) {
            this.viewer.removeFilter((ViewerFilter)this.filter);
        }
        this.filter = filter;
        this.viewer.addFilter((ViewerFilter)filter);
    }

    protected void runInUIThread(Runnable runnable) {
        this.getDisplay().asyncExec(runnable);
    }

    private void copySelectionToClipboard() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            StringBuilder sb = new StringBuilder();
            String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(0));
                int j = 1;
                while (j < this.viewer.getTable().getColumnCount()) {
                    sb.append('\t');
                    sb.append(selection[i].getText(j));
                    ++j;
                }
                ++i;
            }
            WidgetHelper.copyToClipboard(sb.toString());
        }
    }

    public Action getActionPause() {
        return this.actionPause;
    }

    public Action getActionShowFilter() {
        return this.actionShowFilter;
    }

    public Action getActionCopy() {
        return this.actionCopy;
    }
}

