/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AccessPointState;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.topology.RadioInterface;

public class AccessPoint
extends DataCollectionTarget {
    private long nodeId;
    private int index;
    private MacAddress macAddress;
    private InetAddress ipAddress;
    private AccessPointState state;
    private String vendor;
    private String model;
    private String serialNumber;
    private RadioInterface[] radios;

    public AccessPoint(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.nodeId = msg.getFieldAsInt64(393L);
        this.index = msg.getFieldAsInt32(495L);
        this.macAddress = new MacAddress(msg.getFieldAsBinary(113L));
        this.ipAddress = msg.getFieldAsInetAddress(8L);
        this.state = AccessPointState.getByValue(msg.getFieldAsInt32(243L));
        this.vendor = msg.getFieldAsString(428L);
        this.model = msg.getFieldAsString(429L);
        this.serialNumber = msg.getFieldAsString(432L);
        int count2 = msg.getFieldAsInt32(442L);
        this.radios = new RadioInterface[count2];
        long fieldId = 0x30000000L;
        for (int i = 0; i < count2; ++i) {
            this.radios[i] = new RadioInterface(this, msg, fieldId);
            fieldId += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "AccessPoint";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getIndex() {
        return this.index;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModel() {
        return this.model;
    }

    public RadioInterface[] getRadios() {
        return this.radios;
    }

    public AccessPointState getState() {
        return this.state;
    }
}

