/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.TableRow;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableItemComparator
extends ViewerComparator {
    private int[] formats;

    public TableItemComparator(int[] formats) {
        this.formats = formats;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int format = column < this.formats.length ? this.formats[column] : 4;
        String value1 = ((TableRow)e1).get(column).getValue();
        String value2 = ((TableRow)e2).get(column).getValue();
        switch (format) {
            case 4: {
                result = value1.compareToIgnoreCase(value2);
                break;
            }
            case 0: {
                try {
                    result = Integer.parseInt(value1) - Integer.parseInt(value2);
                }
                catch (NumberFormatException numberFormatException) {
                    result = 0;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                try {
                    result = Long.signum(Long.parseLong(value1) - Long.parseLong(value2));
                }
                catch (NumberFormatException numberFormatException) {
                    result = 0;
                }
                break;
            }
            case 5: {
                try {
                    result = (int)Math.signum(Double.parseDouble(value1) - Double.parseDouble(value2));
                }
                catch (NumberFormatException numberFormatException) {
                    result = 0;
                }
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

