/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import java.util.Iterator;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;

public class ObjectTreeContentProvider
extends TreeNodeContentProvider {
    private NXCSession session = null;
    private long[] rootObjects = null;

    public ObjectTreeContentProvider(long[] rootObjects) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        }
    }

    public Object[] getChildren(Object parentElement) {
        return ((AbstractObject)parentElement).getChildsAsArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.session != null) {
            return this.rootObjects != null ? this.session.findMultipleObjects(this.rootObjects, false).toArray() : this.session.getTopLevelObjects();
        }
        return new AbstractObject[0];
    }

    public Object getParent(Object element) {
        if (this.session == null) {
            return null;
        }
        Iterator it = ((AbstractObject)element).getParents();
        return it.hasNext() ? this.session.findObjectById(((Long)it.next()).longValue()) : null;
    }

    public boolean hasChildren(Object element) {
        return ((AbstractObject)element).hasAccessibleChildren();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.session = (NXCSession)newInput;
    }

    public void setRootObjects(long[] rootObjects) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        } else {
            this.rootObjects = null;
        }
    }
}

