/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeneralTable
extends PropertyPage {
    private DataCollectionObjectEditor editor;
    private DataCollectionTable dci;
    private AbstractObject owner;
    private Cluster cluster = null;
    private Map<Integer, Long> clusterResourceMap;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private ObjectSelector sourceNode;
    private Combo agentCacheMode;
    private Combo schedulingMode;
    private Combo retentionMode;
    private LabeledSpinner pollingInterval;
    private LabeledSpinner retentionTime;
    private Combo clusterResource;
    private Button statusActive;
    private Button statusDisabled;
    private Button statusUnsupported;

    protected Control createContents(Composite parent) {
        this.editor = (DataCollectionObjectEditor)this.getElement().getAdapter(DataCollectionObjectEditor.class);
        this.dci = this.editor.getObjectAsTable();
        NXCSession session = ConsoleSharedData.getSession();
        this.owner = session.findObjectById(this.dci.getNodeId());
        if (this.owner instanceof Cluster) {
            this.cluster = (Cluster)this.owner;
        } else if (this.owner instanceof AbstractNode) {
            AbstractObject[] abstractObjectArray = this.owner.getParentsAsArray();
            int n = abstractObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject o = abstractObjectArray[n2];
                if (o instanceof Cluster) {
                    this.cluster = (Cluster)o;
                    break;
                }
                ++n2;
            }
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        Messages.get();
        groupDescription.setText(Messages.GeneralTable_Description);
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        Messages.get();
        groupData.setText(Messages.GeneralTable_Data);
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        Messages.get();
        this.parameter.setLabel(Messages.GeneralTable_Parameter);
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        Messages.get();
        this.selectButton.setText(Messages.GeneralTable_Select);
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.selectParameter();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(50, -2);
        Messages.get();
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.GeneralTable_Origin, (Object)fd);
        Messages.get();
        this.origin.add(Messages.GeneralTable_SourceInternal);
        Messages.get();
        this.origin.add(Messages.GeneralTable_SourceAgent);
        Messages.get();
        this.origin.add(Messages.GeneralTable_SourceSNMP);
        Messages.get();
        this.origin.add(Messages.GeneralTable_SourceCPSNMP);
        Messages.get();
        this.origin.add(Messages.GeneralTable_SourcePush);
        this.origin.select(this.dci.getOrigin());
        this.origin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.onOriginChange();
            }
        });
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkUseCustomSnmpPort.setText(Messages.GeneralTable_UseCustomSNMPPort);
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.customSnmpPort.setEnabled(GeneralTable.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == 2);
        this.customSnmpPort = new Spinner((Composite)groupData, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dci.getOrigin() == 2 && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dci.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.sourceNode = new ObjectSelector((Composite)groupData, 0, true);
        Messages.get();
        this.sourceNode.setLabel(Messages.GeneralTable_ProxyNode);
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dci.getSourceNode());
        this.sourceNode.setEnabled(this.dci.getOrigin() != 4);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.origin.getParent(), 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)"Agent cache mode", (Object)fd);
        this.agentCacheMode.add("Default");
        this.agentCacheMode.add("On");
        this.agentCacheMode.add("Off");
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.agentCacheMode.setEnabled(this.dci.getOrigin() == 1 || this.dci.getOrigin() == 2);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.origin.getParent(), 4, 1024);
        fd.right = new FormAttachment((Control)this.agentCacheMode.getParent(), -4, 16384);
        this.sourceNode.setLayoutData((Object)fd);
        Group groupPolling = new Group(dialogArea, 0);
        Messages.get();
        groupPolling.setText(Messages.GeneralTable_Polling);
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.GeneralTable_PollingMode, (Object)fd);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsDefault);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsCustom);
        Messages.get();
        this.schedulingMode.add(Messages.General_CustomSchedule);
        this.schedulingMode.select(this.dci.isUseAdvancedSchedule() ? 2 : (this.dci.getPollingInterval() > 0 ? 1 : 0));
        this.schedulingMode.setEnabled(this.dci.getOrigin() != 4);
        this.schedulingMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.pollingInterval.setEnabled(GeneralTable.this.schedulingMode.getSelectionIndex() == 1);
            }
        });
        this.pollingInterval = new LabeledSpinner((Composite)groupPolling, 0);
        Messages.get();
        this.pollingInterval.setLabel(Messages.General_PollingInterval);
        this.pollingInterval.setRange(1, 99999);
        this.pollingInterval.setSelection(this.dci.getPollingInterval() > 0 ? this.dci.getPollingInterval() : ConsoleSharedData.getSession().getDefaultDciPollingInterval());
        this.pollingInterval.setEnabled(!this.dci.isUseAdvancedSchedule() && this.dci.getPollingInterval() > 0 && this.dci.getOrigin() != 4);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.schedulingMode.getParent(), 4, 1024);
        Messages.get();
        this.clusterResource = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.GeneralTable_ClRes, (Object)fd);
        if (this.cluster != null) {
            this.clusterResourceMap = new HashMap<Integer, Long>();
            this.clusterResourceMap.put(0, 0L);
            Messages.get();
            this.clusterResource.add(Messages.GeneralTable_None);
            if (this.dci.getResourceId() == 0L) {
                this.clusterResource.select(0);
            }
            int index = 1;
            for (ClusterResource r : this.cluster.getResources()) {
                this.clusterResource.add(r.getName());
                this.clusterResourceMap.put(index, r.getId());
                if (this.dci.getResourceId() == r.getId()) {
                    this.clusterResource.select(index);
                }
                ++index;
            }
        } else {
            Messages.get();
            this.clusterResource.add(Messages.GeneralTable_None);
            this.clusterResource.select(0);
            this.clusterResource.setEnabled(false);
        }
        Group groupStatus = new Group(dialogArea, 0);
        Messages.get();
        groupStatus.setText(Messages.GeneralTable_Status);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupStatus.setLayoutData((Object)gd);
        RowLayout statusLayout = new RowLayout();
        statusLayout.type = 512;
        groupStatus.setLayout((Layout)statusLayout);
        this.statusActive = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusActive.setText(Messages.GeneralTable_Active);
        this.statusActive.setSelection(this.dci.getStatus() == 0);
        this.statusDisabled = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusDisabled.setText(Messages.GeneralTable_Disabled);
        this.statusDisabled.setSelection(this.dci.getStatus() == 1);
        this.statusUnsupported = new Button((Composite)groupStatus, 16);
        Messages.get();
        this.statusUnsupported.setText(Messages.GeneralTable_NotSupported);
        this.statusUnsupported.setSelection(this.dci.getStatus() == 2);
        Group groupStorage = new Group(dialogArea, 0);
        Messages.get();
        groupStorage.setText(Messages.GeneralTable_Storage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        GridLayout storageLayout = new GridLayout();
        storageLayout.numColumns = 2;
        storageLayout.horizontalSpacing = 4;
        groupStorage.setLayout((Layout)storageLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.retentionMode = WidgetHelper.createLabeledCombo((Composite)groupStorage, (int)8, (String)"Retention mode", (Object)gd);
        this.retentionMode.add("Use default retention time");
        this.retentionMode.add("Use custom retention time");
        Messages.get();
        this.retentionMode.add(Messages.GeneralTable_NoStorage);
        this.retentionMode.select((this.dci.getFlags() & 0x200) != 0 ? 2 : (this.dci.getRetentionTime() > 0 ? 1 : 0));
        this.retentionMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int mode = GeneralTable.this.retentionMode.getSelectionIndex();
                GeneralTable.this.retentionTime.setEnabled(mode == 1);
            }
        });
        this.retentionTime = new LabeledSpinner((Composite)groupStorage, 0);
        Messages.get();
        this.retentionTime.setLabel(Messages.GeneralTable_RetentionTime);
        this.retentionTime.setRange(1, 99999);
        this.retentionTime.setSelection(this.dci.getRetentionTime() > 0 ? this.dci.getRetentionTime() : ConsoleSharedData.getSession().getDefaultDciRetentionTime());
        this.retentionTime.setEnabled((this.dci.getFlags() & 0x200) == 0 && this.dci.getRetentionTime() > 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void onOriginChange() {
        int index = this.origin.getSelectionIndex();
        this.sourceNode.setEnabled(index != 4);
        this.schedulingMode.setEnabled(index != 4);
        this.pollingInterval.setEnabled(index != 4 && this.schedulingMode.getSelectionIndex() == 1);
        this.checkUseCustomSnmpPort.setEnabled(index == 2);
        this.customSnmpPort.setEnabled(index == 2 && this.checkUseCustomSnmpPort.getSelection());
        this.agentCacheMode.setEnabled(index == 1 || index == 2);
    }

    private void selectParameter() {
        IParameterSelectionDialog dlg;
        switch (this.origin.getSelectionIndex()) {
            case 1: {
                dlg = new SelectAgentParamDlg(this.getShell(), this.dci.getNodeId(), true);
                break;
            }
            case 2: 
            case 3: {
                SnmpObjectId oid;
                try {
                    oid = SnmpObjectId.parseSnmpObjectId((String)this.parameter.getText());
                }
                catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
                    oid = null;
                }
                dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.dci.getNodeId());
                break;
            }
            default: {
                dlg = null;
            }
        }
        if (dlg != null && dlg.open() == 0) {
            IParameterSelectionDialog pd = dlg;
            this.description.setText(pd.getParameterDescription());
            this.parameter.setText(pd.getParameterName());
            this.editor.fireOnSelectTableListeners(this.origin.getSelectionIndex(), pd.getParameterName(), pd.getParameterDescription());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(this.origin.getSelectionIndex());
        this.dci.setSourceNode(this.sourceNode.getObjectId());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setUseAdvancedSchedule(this.schedulingMode.getSelectionIndex() == 2);
        this.dci.setPollingInterval(this.schedulingMode.getSelectionIndex() == 0 ? 0 : this.pollingInterval.getSelection());
        this.dci.setRetentionTime(this.retentionMode.getSelectionIndex() == 0 ? 0 : this.retentionTime.getSelection());
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(Integer.parseInt(this.customSnmpPort.getText()));
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.statusActive.getSelection()) {
            this.dci.setStatus(0);
        } else if (this.statusDisabled.getSelection()) {
            this.dci.setStatus(1);
        } else if (this.statusUnsupported.getSelection()) {
            this.dci.setStatus(2);
        }
        if (this.retentionMode.getSelectionIndex() == 2) {
            this.dci.setFlags(this.dci.getFlags() | 0x200);
        } else {
            this.dci.setFlags(this.dci.getFlags() & 0xFFFFFDFF);
        }
        if (this.cluster != null) {
            this.dci.setResourceId(this.clusterResourceMap.get(this.clusterResource.getSelectionIndex()).longValue());
        }
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.schedulingMode.select(0);
        this.pollingInterval.setSelection(60);
        this.statusActive.setSelection(true);
        this.statusDisabled.setSelection(false);
        this.statusUnsupported.setSelection(false);
        this.retentionTime.setSelection(30);
        this.checkUseCustomSnmpPort.setSelection(false);
    }
}

