/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ConnectionPointComparator
extends ViewerComparator {
    private ITableLabelProvider labelProvider;
    private NXCSession session = ConsoleSharedData.getSession();

    public ConnectionPointComparator(ITableLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 0: {
                result = (Integer)((ConnectionPoint)e1).getData() - (Integer)((ConnectionPoint)e2).getData();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                result = this.labelProvider.getColumnText(e1, column).compareToIgnoreCase(this.labelProvider.getColumnText(e2, column));
                break;
            }
            case 4: {
                Interface iface1 = (Interface)this.session.findObjectById(((ConnectionPoint)e1).getLocalInterfaceId(), Interface.class);
                Interface iface2 = (Interface)this.session.findObjectById(((ConnectionPoint)e2).getLocalInterfaceId(), Interface.class);
                InetAddress a1 = ((ConnectionPoint)e1).getLocalIpAddress();
                InetAddress a2 = ((ConnectionPoint)e2).getLocalIpAddress();
                if (a1 == null && iface1 != null) {
                    a1 = iface1.getFirstUnicastAddress();
                }
                if (a2 == null && iface2 != null) {
                    a2 = iface2.getFirstUnicastAddress();
                }
                result = ComparatorHelper.compareInetAddresses((InetAddress)a1, (InetAddress)a2);
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

