/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.service.SmtpSender;
import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class SmtpSenderImpl
implements SmtpSender {
    Logger log = LoggerFactory.getLogger(SmtpSenderImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="#{serverSettings.smtpFrom}")
    private String from;

    @Override
    public void mail(String to, String subject, String body, String fileName, File file) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from);
            helper.setTo(to);
            helper.setSubject(subject);
            if (fileName != null && file != null) {
                helper.addAttachment(fileName, file);
            }
            helper.setText(body);
            this.mailSender.send(message);
        }
        catch (MessagingException e) {
            this.log.error("Unable to send notification mail", (Throwable)e);
        }
    }

    public void setFrom(String from) {
        this.from = from;
    }
}

