/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class JRSqlAbstractInClause
implements JRClauseFunction {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_DB_COLUMN_TOKEN_MISSING = "query.in.clause.db.column.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_INVALID_PARAMETER_TYPE = "query.in.clause.invalid.parameter.type";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_PARAMETER_TOKEN_MISSING = "query.in.clause.parameter.token.missing";
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;
    protected static final String CLAUSE_TRUISM = "0 = 0";

    protected JRSqlAbstractInClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_DB_COLUMN_TOKEN_MISSING, (Object[])null);
        }
        if (param == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        StringBuffer sbuffer = queryContext.queryBuffer();
        Object paramValue = queryContext.getValueParameter(param).getValue();
        if (paramValue == null) {
            this.handleNoValues(queryContext);
        } else {
            Collection<?> paramCollection = this.convert(param, paramValue);
            int count = paramCollection.size();
            Iterator<?> it = paramCollection.iterator();
            if (count == 0) {
                this.handleNoValues(queryContext);
            } else {
                StringBuffer nullSbuffer = new StringBuffer();
                StringBuffer notNullSbuffer = new StringBuffer();
                boolean nullFound = false;
                boolean notNullFound = false;
                int idx = 0;
                ArrayList notNullQueryParameters = new ArrayList();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (element == null) {
                        if (nullFound) continue;
                        nullFound = true;
                        nullSbuffer.append(col);
                        nullSbuffer.append(' ');
                        this.appendNullOperator(nullSbuffer);
                        continue;
                    }
                    if (!notNullFound) {
                        notNullFound = true;
                        notNullSbuffer.append(col);
                        notNullSbuffer.append(' ');
                        this.appendInOperator(notNullSbuffer);
                        notNullSbuffer.append(' ');
                        notNullSbuffer.append('(');
                    }
                    if (idx > 0) {
                        notNullSbuffer.append(", ");
                    }
                    notNullSbuffer.append('?');
                    notNullQueryParameters.add(element);
                    ++idx;
                }
                if (nullFound) {
                    if (notNullFound) {
                        sbuffer.append("( ");
                        sbuffer.append(nullSbuffer);
                        this.appendAndOrOperator(sbuffer);
                    } else {
                        sbuffer.append(nullSbuffer);
                    }
                }
                if (notNullFound) {
                    notNullSbuffer.append(')');
                    if (nullFound) {
                        notNullSbuffer.append(" )");
                    }
                    sbuffer.append(notNullSbuffer);
                    queryContext.addQueryMultiParameters(param, count, nullFound);
                }
            }
        }
    }

    protected void handleNoValues(JRQueryClauseContext queryContext) {
        queryContext.queryBuffer().append(CLAUSE_TRUISM);
    }

    protected Collection<?> convert(String paramName, Object paramValue) {
        ArrayList<Object> paramCollection;
        if (paramValue.getClass().isArray()) {
            int size = Array.getLength(paramValue);
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                list.add(Array.get(paramValue, i));
            }
            paramCollection = list;
        } else if (paramValue instanceof Collection) {
            paramCollection = (ArrayList<Object>)paramValue;
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_IN_CLAUSE_INVALID_PARAMETER_TYPE, new Object[]{paramValue.getClass().getName(), paramName});
        }
        return paramCollection;
    }

    protected abstract void appendInOperator(StringBuffer var1);

    protected abstract void appendNullOperator(StringBuffer var1);

    protected abstract void appendAndOrOperator(StringBuffer var1);
}

