/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<Integer, String> originTexts = new HashMap();
    private HashMap<Integer, String> dtTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        Integer n = 1;
        Messages.get();
        this.originTexts.put(n, Messages.DciLabelProvider_SourceAgent);
        Integer n2 = 2;
        Messages.get();
        this.originTexts.put(n2, Messages.DciLabelProvider_SourceSNMP);
        Integer n3 = 3;
        Messages.get();
        this.originTexts.put(n3, Messages.DciLabelProvider_SourceCPSNMP);
        Integer n4 = 0;
        Messages.get();
        this.originTexts.put(n4, Messages.DciLabelProvider_SourceInternal);
        Integer n5 = 4;
        Messages.get();
        this.originTexts.put(n5, Messages.DciLabelProvider_SourcePush);
        Integer n6 = 5;
        Messages.get();
        this.originTexts.put(n6, Messages.DciLabelProvider_SourceWinPerf);
        Integer n7 = 6;
        Messages.get();
        this.originTexts.put(n7, Messages.DciLabelProvider_SourceILO);
        Integer n8 = 7;
        Messages.get();
        this.originTexts.put(n8, Messages.DciLabelProvider_SourceScript);
        Integer n9 = 0;
        Messages.get();
        this.statusTexts.put(n9, Messages.DciLabelProvider_Active);
        Integer n10 = 1;
        Messages.get();
        this.statusTexts.put(n10, Messages.DciLabelProvider_Disabled);
        Integer n11 = 2;
        Messages.get();
        this.statusTexts.put(n11, Messages.DciLabelProvider_NotSupported);
        Integer n12 = 0;
        Messages.get();
        this.dtTexts.put(n12, Messages.DciLabelProvider_DT_int32);
        Integer n13 = 1;
        Messages.get();
        this.dtTexts.put(n13, Messages.DciLabelProvider_DT_uint32);
        Integer n14 = 2;
        Messages.get();
        this.dtTexts.put(n14, Messages.DciLabelProvider_DT_int64);
        Integer n15 = 3;
        Messages.get();
        this.dtTexts.put(n15, Messages.DciLabelProvider_DT_uint64);
        Integer n16 = 5;
        Messages.get();
        this.dtTexts.put(n16, Messages.DciLabelProvider_DT_float);
        Integer n17 = 4;
        Messages.get();
        this.dtTexts.put(n17, Messages.DciLabelProvider_DT_string);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    return this.dtTexts.get(((DataCollectionItem)dci).getDataType());
                }
                Messages.get();
                return Messages.DciLabelProvider_Table;
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    Messages.get();
                    return Messages.DciLabelProvider_CustomSchedule;
                }
                if (dci.getPollingInterval() <= 0) {
                    return "default";
                }
                return Integer.toString(dci.getPollingInterval());
            }
            case 6: {
                String string;
                if ((dci.getFlags() & 0x200) != 0) {
                    return "none";
                }
                int days = dci.getRetentionTime();
                if (days <= 0) {
                    return "default";
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Integer.toString(days)));
                if (days == 1) {
                    Messages.get();
                    string = Messages.DciLabelProvider_Day;
                } else {
                    Messages.get();
                    string = Messages.DciLabelProvider_Days;
                }
                return stringBuilder.append(string).toString();
            }
            case 7: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                int i;
                List list;
                StringBuilder thresholds = new StringBuilder();
                if (dci instanceof DataCollectionItem) {
                    list = ((DataCollectionItem)dci).getThresholds();
                    i = 0;
                    while (i < ((ArrayList)list).size()) {
                        Threshold tr = (Threshold)((ArrayList)list).get(i);
                        int f = tr.getFunction();
                        StringBuilder text = new StringBuilder(ThresholdLabelProvider.FUNCTIONS[f]);
                        if (f != 3) {
                            text.append(tr.getSampleCount());
                            text.append(") ");
                        } else {
                            text.append(' ');
                        }
                        if (f != 6) {
                            text.append(ThresholdLabelProvider.OPERATIONS[tr.getOperation()]);
                            text.append(' ');
                            text.append(tr.getValue());
                        }
                        thresholds.append((CharSequence)text);
                        if (i + 1 != ((ArrayList)list).size()) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                if (dci instanceof DataCollectionTable) {
                    list = ((DataCollectionTable)dci).getThresholds();
                    i = 0;
                    while (i < list.size()) {
                        thresholds.append(((TableThreshold)list.get(i)).getConditionAsText());
                        if (i + 1 != list.size()) {
                            thresholds.append(", ");
                        }
                        ++i;
                    }
                }
                return thresholds.toString();
            }
            case 9: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(dci.getTemplateId());
                if (object == null) {
                    Messages.get();
                    return Messages.DciLabelProvider_Unknown;
                }
                if (!(object instanceof Template)) {
                    return object.getObjectName();
                }
                Set parents = object.getAllParents(null);
                StringBuilder sb = new StringBuilder();
                for (AbstractObject parent : parents) {
                    sb.append(parent.getObjectName());
                    sb.append("/");
                }
                sb.append(object.getObjectName());
                return sb.toString();
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

