/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetDataSet
implements IResultSetDataSet {
    protected final int[] iaColumnIndexes;
    protected final long lStartRow;
    protected final long lEndRow;
    protected Iterator<?> it;
    protected long lRow = 0L;
    protected final ResultSetWrapper rsw;
    protected final List<?> lst;
    protected final Object[] oaTuple;
    protected final int iColumnCount;
    protected final boolean listMode;
    protected final int listDataType;

    public ResultSetDataSet(ResultSetWrapper rsw, int[] iaColumnIndexes, long lStartRow, long lEndRow) {
        this.rsw = rsw;
        this.lst = null;
        this.iColumnCount = iaColumnIndexes.length;
        this.iaColumnIndexes = iaColumnIndexes;
        this.lStartRow = lStartRow;
        this.lEndRow = lEndRow;
        this.oaTuple = new Object[iaColumnIndexes.length];
        this.listMode = false;
        this.listDataType = 0;
        this.reset();
    }

    public ResultSetDataSet(List<?> lst, int dataType) {
        this.rsw = null;
        this.lst = lst;
        this.iColumnCount = 1;
        this.iaColumnIndexes = new int[1];
        this.lStartRow = 0L;
        this.lEndRow = lst.size();
        this.oaTuple = new Object[this.iColumnCount];
        this.listMode = true;
        this.listDataType = dataType;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.lRow < this.lEndRow;
    }

    @Override
    public Object[] next() {
        ++this.lRow;
        if (this.lRow > this.lEndRow) {
            return null;
        }
        if (this.listMode) {
            this.oaTuple[0] = this.it.next();
        } else {
            Object[] oaResultSet = (Object[])this.it.next();
            int i = 0;
            while (i < this.iColumnCount) {
                if (this.iaColumnIndexes[i] != -1) {
                    this.oaTuple[i] = oaResultSet[this.iaColumnIndexes[i]];
                }
                ++i;
            }
        }
        return this.oaTuple;
    }

    @Override
    public int getDataType() {
        if (this.listMode) {
            return this.listDataType;
        }
        if (this.iaColumnIndexes.length >= 1) {
            return this.rsw.getColumnDataType(this.iaColumnIndexes[0]);
        }
        return 0;
    }

    @Override
    public int getDataType(int columnIndex) {
        if (this.listMode) {
            return this.listDataType;
        }
        if (columnIndex < this.iaColumnIndexes.length) {
            return this.rsw.getColumnDataType(this.iaColumnIndexes[columnIndex]);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.iColumnCount;
    }

    @Override
    public long getSize() {
        return this.lEndRow - this.lStartRow;
    }

    @Override
    public void reset() {
        this.lRow = 0L;
        if (this.rsw != null) {
            this.it = this.rsw.iterator();
            if (this.lRow < this.lStartRow) {
                while (this.lRow < this.lStartRow) {
                    ++this.lRow;
                    this.it.next();
                }
            }
        } else {
            this.it = this.lst.iterator();
        }
    }
}

