/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerCommandResults
extends AbstractCommandResults
implements TextOutputListener {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ServerCommandResults";
    private IOConsoleOutputStream out;
    private String lastCommand = null;
    private Action actionRestart;
    private Map<String, String> lastInputValues = null;

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                ServerCommandResults.this.executeCommand(ServerCommandResults.this.lastCommand, ServerCommandResults.this.lastInputValues);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeCommand(final String command, final Map<String, String> inputValues) {
        this.actionRestart.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        this.out = this.console.newOutputStream();
        this.lastCommand = command;
        this.lastInputValues = inputValues;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, session.getObjectName(ServerCommandResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    session.executeServerCommand(ServerCommandResults.this.nodeId, command, inputValues, true, (TextOutputListener)ServerCommandResults.this, null);
                    IOConsoleOutputStream iOConsoleOutputStream = ServerCommandResults.this.out;
                    Messages.get();
                    iOConsoleOutputStream.write(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    if (ServerCommandResults.this.out != null) {
                        ServerCommandResults.this.out.close();
                        ServerCommandResults.this.out = null;
                    }
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerCommandResults.this.actionRestart.setEnabled(true);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {}
    }

    public void dispose() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            this.out = null;
        }
        super.dispose();
    }
}

