/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.objects.Node;
import org.netxms.client.server.AgentFile;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.CreateFolderDialog;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToAgentFolderUploadDialog;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.filemanager.views.AgentFileViewer;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileComparator;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileFilter;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileLabelProvider;
import org.netxms.ui.eclipse.filemanager.views.helpers.ViewAgentFilesProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AgentFileManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileManager";
    private static final String TABLE_CONFIG_PREFIX = "AgentFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    public static final int COLUMN_OWNER = 4;
    public static final int COLUMN_GROUP = 5;
    public static final int COLUMN_ACCESS_RIGHTS = 6;
    private boolean filterEnabled = false;
    private Composite content;
    private AgentFile[] files;
    private AgentFileFilter filter;
    private FilterText filterText;
    private SortableTreeViewer viewer;
    private NXCSession session;
    private Action actionRefreshAll;
    private Action actionUploadFile;
    private Action actionUploadFolder;
    private Action actionDelete;
    private Action actionRename;
    private Action actionRefreshDirectory;
    private Action actionShowFilter;
    private Action actionDownloadFile;
    private Action actionTailFile;
    private Action actionShowFile;
    private Action actionCreateDirectory;
    private long objectId = 0L;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.objectId = Long.parseLong(site.getSecondaryId());
        Messages.get();
        this.setPartName(String.format(Messages.AgentFileManager_PartTitle, this.session.getObjectName(this.objectId)));
    }

    public void createPartControl(Composite parent) {
        String[] columnNames;
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentFileManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                AgentFileManager.this.enableFilter(false);
            }
        });
        String os = ((Node)this.session.findObjectById(this.objectId)).getSystemDescription();
        if (os.contains("Windows")) {
            String[] stringArray = new String[5];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_ColName;
            Messages.get();
            stringArray[1] = Messages.AgentFileManager_ColType;
            Messages.get();
            stringArray[2] = Messages.AgentFileManager_ColSize;
            Messages.get();
            stringArray[3] = Messages.AgentFileManager_ColDate;
            stringArray[4] = "Owner";
            columnNames = stringArray;
            int[] columnWidths = new int[]{300, 120, 150, 150, 150};
            this.viewer = new SortableTreeViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        } else {
            String[] stringArray = new String[7];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_ColName;
            Messages.get();
            stringArray[1] = Messages.AgentFileManager_ColType;
            Messages.get();
            stringArray[2] = Messages.AgentFileManager_ColSize;
            Messages.get();
            stringArray[3] = Messages.AgentFileManager_ColDate;
            stringArray[4] = "Owner";
            stringArray[5] = "Group";
            stringArray[6] = "Access Rights";
            columnNames = stringArray;
            int[] columnWidths = new int[]{300, 120, 150, 150, 150, 150, 200};
            this.viewer = new SortableTreeViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        }
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ViewAgentFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AgentFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AgentFileComparator());
        this.filter = new AgentFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    AgentFileManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)AgentFileManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)AgentFileManager.TABLE_CONFIG_PREFIX);
            }
        });
        this.enableDragSupport();
        this.enableDropSupport();
        this.enableInPlaceRename();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshFileList();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.filemanager.context.AgentFileManager");
        }
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(3, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(AgentFileManager.this.viewer.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        });
    }

    public void enableDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)data;
                List movableSelection = selection.toList();
                int i = 0;
                while (i < movableSelection.size()) {
                    AgentFile movableObject = (AgentFile)movableSelection.get(i);
                    AgentFileManager.this.moveFile((AgentFile)this.getCurrentTarget(), movableObject);
                    ++i;
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null || !LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                for (Object object : selection.toList()) {
                    if (object instanceof AgentFile) continue;
                    return false;
                }
                if (!(target instanceof AgentFile)) {
                    return false;
                }
                return ((AgentFile)target).isDirectory();
            }
        });
    }

    private void enableInPlaceRename() {
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.viewer.getTree())});
        this.viewer.setColumnProperties(new String[]{"name"});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (property.equals("name") && element instanceof AgentFile) {
                    AgentFileManager.this.doRename((AgentFile)element, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                if (property.equals("name") && element instanceof AgentFile) {
                    return ((AgentFile)element).getName();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return property.equals("name");
            }
        });
    }

    private void doRename(final AgentFile agentFile, final String newName) {
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_RenameError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, agentFile.getFullName(), String.valueOf(agentFile.getParent().getFullName()) + "/" + newName);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        agentFile.setName(newName);
                        AgentFileManager.this.viewer.refresh((Object)agentFile, true);
                    }
                });
            }
        }.start();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionRefreshDirectory = new Action(Messages.AgentFileManager_RefreshFolder, SharedIcons.REFRESH){

            public void run() {
                AgentFileManager.this.refreshFileOrDirectory();
            }
        };
        this.actionRefreshDirectory.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.refreshFolder");
        handlerService.activateHandler(this.actionRefreshDirectory.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRefreshDirectory));
        this.actionRefreshAll = new RefreshAction((IViewPart)this){

            public void run() {
                AgentFileManager.this.refreshFileList();
            }
        };
        Messages.get();
        this.actionUploadFile = new Action(Messages.AgentFileManager_UploadFile){

            public void run() {
                AgentFileManager.this.uploadFile();
            }
        };
        this.actionUploadFile.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.uploadFile");
        handlerService.activateHandler(this.actionUploadFile.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionUploadFile));
        Messages.get();
        this.actionUploadFolder = new Action(Messages.AgentFileManager_UploadFolder){

            public void run() {
                AgentFileManager.this.uploadFolder();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.AgentFileManager_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                AgentFileManager.this.deleteFile();
            }
        };
        this.actionDelete.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.delete");
        handlerService.activateHandler(this.actionDelete.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDelete));
        Messages.get();
        this.actionRename = new Action(Messages.AgentFileManager_Rename){

            public void run() {
                AgentFileManager.this.renameFile();
            }
        };
        this.actionRename.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.rename");
        handlerService.activateHandler(this.actionRename.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRename));
        Messages.get();
        this.actionShowFilter = new Action(Messages.ViewServerFile_ShowFilterAction, 2){

            public void run() {
                AgentFileManager.this.enableFilter(!AgentFileManager.this.filterEnabled);
                AgentFileManager.this.actionShowFilter.setChecked(AgentFileManager.this.filterEnabled);
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        Messages.get();
        this.actionDownloadFile = new Action(Messages.AgentFileManager_Download){

            public void run() {
                AgentFileManager.this.startDownload();
            }
        };
        this.actionDownloadFile.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.download");
        handlerService.activateHandler(this.actionDownloadFile.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDownloadFile));
        this.actionTailFile = new Action("Tail"){

            public void run() {
                AgentFileManager.this.tailFile(true, 1024);
            }
        };
        Messages.get();
        this.actionShowFile = new Action(Messages.AgentFileManager_Show){

            public void run() {
                AgentFileManager.this.tailFile(false, 0);
            }
        };
        Messages.get();
        this.actionCreateDirectory = new Action(Messages.AgentFileManager_CreateFolder){

            public void run() {
                AgentFileManager.this.createFolder();
            }
        };
        this.actionCreateDirectory.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.newFolder");
        handlerService.activateHandler(this.actionCreateDirectory.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCreateDirectory));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefreshAll);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefreshAll);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AgentFileManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionUploadFile);
                mgr.add((IAction)this.actionUploadFolder);
            } else {
                mgr.add((IAction)this.actionTailFile);
                mgr.add((IAction)this.actionShowFile);
            }
            mgr.add((IAction)this.actionDownloadFile);
            mgr.add((IContributionItem)new Separator());
        }
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionCreateDirectory);
            }
            mgr.add((IAction)this.actionRename);
        }
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        if (selection.size() == 1 && ((AgentFile)selection.getFirstElement()).isDirectory()) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionRefreshDirectory);
        }
    }

    private void refreshFileList() {
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.files = AgentFileManager.this.session.listAgentFiles(null, "/", AgentFileManager.this.objectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.setInput((Object)AgentFileManager.this.files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void refreshFileOrDirectory() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    if (!((AgentFile)objects[i]).isDirectory()) {
                        objects[i] = ((AgentFile)objects[i]).getParent();
                    }
                    final AgentFile sf = (AgentFile)objects[i];
                    sf.setChildren(AgentFileManager.this.session.listAgentFiles(sf, sf.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)sf);
                        }
                    });
                    ++i;
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void uploadFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final AgentFile upladFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        final StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.AgentFileManager_UploadFileJobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    List<File> fileList = dlg.getLocalFiles();
                    int i = 0;
                    while (i < fileList.size()) {
                        final File localFile = fileList.get(i);
                        String remoteFile = fileList.get(i).getName();
                        if (fileList.size() == 1) {
                            remoteFile = dlg.getRemoteFileName();
                        }
                        session.uploadLocalFileToAgent(localFile, String.valueOf(upladFolder.getFullName()) + "/" + remoteFile, AgentFileManager.this.objectId, new ProgressListener(){
                            private long prevWorkDone = 0L;

                            public void setTotalWorkAmount(long workTotal) {
                                Messages.get();
                                monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + localFile.getAbsolutePath(), (int)workTotal);
                            }

                            public void markProgress(long workDone) {
                                monitor.worked((int)(workDone - this.prevWorkDone));
                                this.prevWorkDone = workDone;
                            }
                        });
                        monitor.done();
                        ++i;
                    }
                    upladFolder.setChildren(session.listAgentFiles(upladFolder, upladFolder.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)upladFolder, true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UploadFileToServer_JobError;
                }
            }.start();
        }
    }

    private void uploadFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final AgentFile upladFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        final StartClientToAgentFolderUploadDialog dlg = new StartClientToAgentFolderUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.AgentFileManager_UploadFolderJobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    File folder = dlg.getLocalFile();
                    session.createFolderOnAgent(String.valueOf(upladFolder.getFullName()) + "/" + dlg.getRemoteFileName(), AgentFileManager.this.objectId);
                    AgentFileManager.this.listFilesForFolder(folder, String.valueOf(upladFolder.getFullName()) + "/" + dlg.getRemoteFileName(), monitor);
                    upladFolder.setChildren(session.listAgentFiles(upladFolder, upladFolder.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)upladFolder, true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UploadFileToServer_JobError;
                }
            }.start();
        }
    }

    public void listFilesForFolder(File folder, String upladFolder, final IProgressMonitor monitor) throws NXCException, IOException {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            final File fileEntry = fileArray[n2];
            if (fileEntry.isDirectory()) {
                this.session.createFolderOnAgent(String.valueOf(upladFolder) + "/" + fileEntry.getName(), this.objectId);
                this.listFilesForFolder(fileEntry, String.valueOf(upladFolder) + "/" + fileEntry.getName(), monitor);
            } else {
                this.session.uploadLocalFileToAgent(fileEntry, String.valueOf(upladFolder) + "/" + fileEntry.getName(), this.objectId, new ProgressListener(){
                    private long prevWorkDone = 0L;

                    public void setTotalWorkAmount(long workTotal) {
                        Messages.get();
                        monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + fileEntry.getAbsolutePath(), (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)(workDone - this.prevWorkDone));
                        this.prevWorkDone = workDone;
                    }
                });
                monitor.done();
            }
            ++n2;
        }
    }

    private void deleteFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ViewServerFile_DeleteConfirmation, (String)Messages.ViewServerFile_DeletAck)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ViewServerFile_ErrorDeleteFileJob;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    final AgentFile sf = (AgentFile)objects[i];
                    AgentFileManager.this.session.deleteAgentFile(AgentFileManager.this.objectId, sf.getFullName());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            sf.getParent().removeChield(sf);
                            AgentFileManager.this.viewer.refresh((Object)sf.getParent());
                        }
                    });
                    ++i;
                }
            }
        }.start();
    }

    private void tailFile(final boolean followChanges, final int offset) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        if (((AgentFile)objects[0]).isDirectory()) {
            return;
        }
        final AgentFile sf = (AgentFile)objects[0];
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.AgentFileManager_DownloadJobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.AgentFileManager_DownloadJobError, sf.getFullName(), AgentFileManager.this.objectId);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFileData file = AgentFileManager.this.session.downloadFileFromAgent(AgentFileManager.this.objectId, sf.getFullName(), (long)offset, followChanges);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String secondaryId = String.valueOf(Long.toString(AgentFileManager.this.objectId)) + "&" + URLEncoder.encode(sf.getName(), "UTF-8");
                            AgentFileViewer.createView(secondaryId, AgentFileManager.this.objectId, file, followChanges);
                        }
                        catch (Exception e) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AgentFileManager_Error, (String)String.format(Messages.AgentFileManager_OpenViewError, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void startDownload() {
        String selected;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final AgentFile sf = (AgentFile)selection.getFirstElement();
        do {
            FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
            Messages.get();
            fd.setText(Messages.AgentFileManager_StartDownloadDialogTitle);
            String[] filterExtensions = new String[]{"*.*"};
            fd.setFilterExtensions(filterExtensions);
            String[] stringArray = new String[1];
            Messages.get();
            stringArray[0] = Messages.AgentFileManager_AllFiles;
            String[] filterNames = stringArray;
            fd.setFilterNames(filterNames);
            fd.setFileName(sf.getName());
            selected = fd.open();
            if (selected != null) continue;
            return;
        } while (selected.isEmpty());
        if (!sf.isDirectory()) {
            this.downloadFile(selected, sf.getFullName());
        }
        final String name = selected;
        if (sf.isDirectory()) {
            Messages.get();
            ConsoleJob job = new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    AgentFileManager.this.downloadDir(sf, name);
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.AgentFileManager_DirectoryReadError;
                }
            };
            job.setUser(false);
            job.start();
        }
    }

    private void downloadDir(AgentFile sf, String localFileName) throws NXCException, IOException {
        File dir = new File(localFileName);
        dir.mkdir();
        AgentFile[] files = sf.getChildren();
        if (files == null) {
            files = this.session.listAgentFiles(sf, sf.getFullName(), sf.getNodeId());
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.downloadDir(files[i], String.valueOf(localFileName) + "/" + sf.getName());
            } else {
                this.downloadFile(String.valueOf(localFileName) + "/" + files[i].getName(), files[i].getFullName());
            }
            ++i;
        }
    }

    private void downloadFile(final String localName, final String remoteName) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.AgentFileManager_DownloadFileFromAgent, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int len;
                AgentFileData file = AgentFileManager.this.session.downloadFileFromAgent(AgentFileManager.this.objectId, remoteName, 0L, false);
                File outputFile = new File(localName);
                outputFile.createNewFile();
                FileInputStream in = new FileInputStream(file.getFile());
                FileOutputStream out = new FileOutputStream(outputFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.AgentFileManager_FileDownloadError, remoteName, AgentFileManager.this.session.getObjectName(AgentFileManager.this.objectId), AgentFileManager.this.objectId);
            }
        };
        job.start();
    }

    private void renameFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        this.viewer.editElement(selection.getFirstElement(), 0);
    }

    private void moveFile(final AgentFile target, final AgentFile object) {
        Messages.get();
        new ConsoleJob(Messages.AgentFileManager_MoveFile, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_MoveError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        object.getParent().removeChield(object);
                        AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                        object.setParent(target);
                        target.addChield(object);
                        AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                    }
                });
            }
        }.start();
    }

    private void createFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final AgentFile parentFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        CreateFolderDialog dlg = new CreateFolderDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        final String newFolder = dlg.getNewName();
        Messages.get();
        new ConsoleJob(Messages.AgentFileManager_CreatingFolder, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AgentFileManager_FolderCreationError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.session.createFolderOnAgent(String.valueOf(parentFolder.getFullName()) + "/" + newFolder, AgentFileManager.this.objectId);
                parentFolder.setChildren(AgentFileManager.this.session.listAgentFiles(parentFolder, parentFolder.getFullName(), AgentFileManager.this.objectId));
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.refresh((Object)parentFolder, true);
                    }
                });
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTree().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

