/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectSelectionProvider
implements ISelectionProvider {
    private ISelectionProvider parent;
    private NXCSession session;

    public ObjectSelectionProvider(ISelectionProvider parent) {
        this.parent = parent;
        this.session = ConsoleSharedData.getSession();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.parent.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.parent.getSelection();
        if (selection == null || selection.isEmpty()) {
            return selection;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(selection.size());
        for (Object o : selection.toList()) {
            AbstractObject object;
            if (!(o instanceof TableRow) || (object = this.session.findObjectById(((TableRow)o).getObjectId())) == null) continue;
            objects.add(object);
        }
        return new StructuredSelection(objects);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.parent.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

