/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.datacollection.widgets.SummaryTableWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SummaryTable
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.SummaryTable";
    private NXCSession session;
    private int tableId;
    private long baseObjectId;
    private SummaryTableWidget viewer;
    private Action actionRefresh;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.tableId = Integer.parseInt(parts[0]);
        this.baseObjectId = Long.parseLong(parts[1]);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SummaryTableWidget(parent, 0, (IViewPart)this, this.tableId, this.baseObjectId);
        this.createActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer.getViewer());
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SummaryTable.this.viewer.refresh();
            }
        };
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer.getViewer(), false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.viewer.getActionUseMultipliers());
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.viewer.getViewer().getTable().setFocus();
    }

    public void setTable(Table table) {
        AbstractObject object = this.session.findObjectById(this.baseObjectId);
        this.setPartName(String.valueOf(table.getTitle()) + " - " + (object != null ? object.getObjectName() : "[" + this.baseObjectId + "]"));
        this.viewer.update(table);
    }
}

